#include "common/th_assert.h"
#include "common/or_obj.h"
#include "objrefs.h"

void Object_References::init(Obj_bitfield b, int slots) {
    bf = b;
    num = slots;
    index = 0;
    all_refs = FALSE;

    th_assert(bf != OBJ_BF_LONG_BF, "Long bitfields unimplemented");

    if (OBJ_BF_SPECIAL(bf)) {
	if (bf == OBJ_BF_ALLDATA) {
	    // No referenes
	    index = num;
	}
	else if (bf == OBJ_BF_ALLREFS) {
	    all_refs = TRUE;
	}
	else {
	    th_fail("unimplemented special bitfield pattern");
	}
    }
}

bool Object_References::slow_get(int& x) {
    while (index < num) {
	if (OBJ_BF_ISREF(bf, index)) {
	    x = index++;
	    return TRUE;
	}
	index++;
    }
    return FALSE;
}
