#ifndef _OBJREFS_H
#define _OBJREFS_H

// Generate indices of all references in an OR_obj.

#include "common/obj_bitfield.h"
#include "common/basic.h"

struct OR_obj;

class Object_References {
  public:
    Object_References(OR_obj* obj);
    // effects	Create a generator that yields the slot numbers of
    //		all ref slots in "obj".

    Object_References(Obj_bitfield bf, int slots);
    // effects	Create a generator that yields the slot numbers of
    //		all ref slots in an object with the specified bitfield
    //		and the specified number of data slots.
    //
    //		This is not enough information for long bitfields
    //		and therefore this operation aborts if a long bf is
    //		passed in.

    bool get(int& x);
    // modifies	this, x
    // effects	If more reference slots are available, modify "x" to
    //		contain the index of the next reference slot and return TRUE.
    //		Else do not modify "x" and return FALSE.
  private:
    Obj_bitfield bf;		// The bitfield
    int  num;			// Number of slots
    int  index;			// Index of next field to check
    bool all_refs;		// All slots are refs?

    bool slow_get(int& x);
    // requires: all_refs is not TRUE (to avoid a check in the code)
    // Slow version of "get".

    // Initialize from bitfield and size
    void init(Obj_bitfield, int slots);
};

inline Object_References::Object_References(OR_obj* o) {
    init(OR_OBJ_BITFIELD(o), OR_OBJ_SIZE(o));
}

inline Object_References::Object_References(Obj_bitfield b, int slots) {
    init(b, slots);
}

inline bool Object_References::get(int& x) {
    if (all_refs) {
	if (index < num) {
	    x = index++;
	    return TRUE;
	}
	return FALSE;
    }

    // Scanning of the bitfield is done in a non-inline routine.
    return slow_get(x);
}

#endif /* _OBJREFS_H */
