/*
\section{OR Index implementation}

This is a thin layer over a hash table.
*/

#include "common/or_index.h"
#include "common/device.h"

implementOpenHashMap(ORIndex, OR_num, int, ORNUM_HASH, ORNUM_EQUAL)

OR_Index::OR_Index() {
    or_index = new ORIndex(1);
}

OR_Index::~OR_Index() {
    delete or_index;
}

void OR_Index::clear() {
    or_index->clear();
}

void OR_Index::store(OR_num or_num, int index) {
    or_index->store(or_num, index);
}

int OR_Index::fetch(OR_num or_num) {
    return or_index->fetch(or_num);
}

bool OR_Index::fetch(OR_num or_num, int& index) {
    return or_index->fetch(or_num, index);
}

int OR_Index::encode_size() const {
    return (sizeof(ubits32) + (or_index->size() * sizeof(ubits32) * 2));
}

bool OR_Index::encode(Device* dev) const {
    // Send size, and then each binding
    if (!dev->send_ubits32(or_index->size()))
	return FALSE;

    ORIndex::Bindings elts(or_index);

    for (; elts.ok(); elts.next()) {
	if (!dev->send_ubits32(elts.key()) ||
	    !dev->send_ubits32(elts.val()))
	    return FALSE;
    }
    return TRUE;
}

bool OR_Index::decode(Device* dev) {
    ubits32 size, i, index;
    OR_num or_num;

    if (!dev->recv_ubits32(&size))
	return FALSE;
    
    for (i=0; i < size; i++) {
	if (!dev->recv_ubits32(&or_num) ||
	    !dev->recv_ubits32(&index))
	    return FALSE;

	or_index->store(or_num, index);
    }
    return TRUE;
}

