/*
\section{OR Index}

This abstraction is a mapping from OR numbers to integers; the
integers are meant to be used as indices into the array of new xrefs
sent by the coordinator to the FE and participants.  Participants need
to know this information so that they can replace temporary names in
modified objects with the xrefs of new objects.

*/

#ifndef _OR_INDEX_H
#define _OR_INDEX_H

#include "common/basic.h"
#include "common/openhashmap.h"
#include "common/or_num.h"

class Device;

// Map from OR number to index
declareOpenHashMap(ORIndex, OR_num, int, ORNUM_HASH, ORNUM_EQUAL)

class OR_Index {
public:
    OR_Index();
    ~OR_Index();

    void clear();
    // effects - Clear all entries from mapping.

    void store(OR_num or_num, int index);
    // effects - Enter mapping from or_num to index, erasing any old mapping.

    int fetch(OR_num or_num);
    // requires - or_num appears in mapping
    // effects  - Returns index bound to or_num.

    bool fetch(OR_num or_num, int& index);
    // effects - If binding exists for or_num, set index to value bound
    //           to or_num and return TRUE.  Otherwise return FALSE.

    int  encode_size() const;
    bool encode(Device* dev) const;
    bool decode(Device* dev);
  
private:
    ORIndex *or_index;
};

#endif /* _OR_INDEX_H */
