#include "common/th_assert.h"
#include "common/iter.h"
#include "common/basic.h"
#include "common/or_obj.h"

implementArray(OR_slot_Array,OR_slot)

int OR_obj_full_size(OR_obj* x) {
    Obj_bitfield bf = OR_OBJ_BITFIELD(x);

    if (bf == OBJ_BF_MOVED)
	// This is a forwarder
	return OR_obj_headers;

    if (OBJ_BF_ISLONG(bf))
	// Incorporate long bitfield size
	return (OR_OBJ_SIZE(x) + OR_obj_headers + OBJ_BF_LONGSIZE(bf));

    // Normal object
    return (OR_OBJ_SIZE(x) + OR_obj_headers);
}

void OR_obj_refs (OR_obj const* obj, struct closure cl) {
/* Iterator yields references (Oref) contained in obj. */
/* See also "objrefs.h" for an alternate approach. */

  void (*f)(void*, Oref) = (void(*)(void*, Oref))cl.f;

  Obj_bitfield bf = OR_OBJ_BITFIELD(obj);

  int numslots = OR_OBJ_SIZE(obj);

  if (bf == OBJ_BF_LONG_BF) {
    th_fail("Long bitfields unimplemented");
  } else {
    if (OBJ_BF_SPECIAL(bf)) {
      switch (bf) {
	case OBJ_BF_ALLDATA:
	break;
      case OBJ_BF_ALLREFS:
	int  i;  
	for (i = 0; i < numslots; i++) {
	  // XXX This does not work for cross-or references
	  (*f)(cl.env, obj->slot[i].xref.oref);
	}	
	break;
      default:
	th_fail("Unknown special bitfield");
      }
    }
    else {      /* bf not special */
      int  i;  
      for (i = 0; i < numslots; i++) {
	if (OBJ_BF_ISREF(bf, i)) {
	  // XXX This does not work for cross-or references
	  (*f)(cl.env, obj->slot[i].xref.oref);
	}
      }
    }
  }  
}

OR_Ref_Gen::OR_Ref_Gen(const OR_obj *obj, OR_num id) {
  object = obj;
  index = 0;
  all_ref = FALSE;
  or_id = id;
  bf = OR_OBJ_BITFIELD(obj);
  numslots = OR_OBJ_SIZE(obj);

  if (bf == OBJ_BF_LONG_BF) {
    th_fail("Long bitfields unimplemented");
  } else {
    if (OBJ_BF_SPECIAL(bf)) {
      switch (bf) {
      case OBJ_BF_ALLDATA:
        index = numslots;     // no orefs to generate
        break;
      case OBJ_BF_ALLREFS:
        all_ref = TRUE;
        skip_non_orefs();
	break;
      default:
	th_fail("Unknown special bitfield");
      }
    }
    else {
      skip_non_orefs();
    }
  }
}

bool OR_Ref_Gen::ok() const {
  return (index < numslots);
}

void OR_Ref_Gen::get(Oref *x, int *slot_no) const {
  *x =  object->slot[index].xref.oref;
  *slot_no = index;
}

void OR_Ref_Gen::next() {
  index++;
  skip_non_orefs();
}

void OR_Ref_Gen::skip_non_orefs() {
  if (all_ref) {                // all slots are references
    while (index < numslots) {
      if (object->slot[index].xref.or == or_id) return;
      index++;
    }
  } else {
    while (index < numslots) {
      if ((OBJ_BF_ISREF(bf, index)) &&
          (object->slot[index].xref.or == or_id)) return;
      index++;
    }
  }
}
