#ifndef _OR_STAT_H
#define _OR_STAT_H

// Statistics reported by OR

#include <stdio.h>
#include "common/basic.h"
#include "common/bits.h"

class Network;

// Time value encoded in "or_stat" message
struct or_st_time {
    ubits32 seconds;
    ubits32 micros;
};

extern void zero_time(or_st_time& t);
// modifies	"t"
// effects	post(t) = 0

extern void get_wallclock_time(or_st_time& t);
// modifies	"t"
// effects	post(t) = wall-clock time

extern void add_time(or_st_time& t, or_st_time const& x);
// modifies	"t"
// effects	post(t) = pre(t) + x

extern void sub_time(or_st_time& t, or_st_time const& x);
// modifies	"t"
// effects	post(t) = pre(t) - x

extern double time_to_seconds(or_st_time const& t);
// effects	Return time in seconds.

// Disk statistic per disk operation type
struct or_st_disk {
    int			count;		// Number of operations
    int			blocks;		// Total blocks transferred for ops
    or_st_time		elapsed;	// Total elapsed time for ops
};

// Structure of "or_stat" message
struct or_stat {
    or_st_time	clock;		// OR wall-clock time when measurement taken
    ubits32	trans;		// Number of xactions committed
    ubits32	mods;		// Number of committed modifications
    ubits32	absorbed;	// Number of absorbed modifications
    ubits32	installs;	// Number of modifications installed in segs
    ubits32	logsize;	// Current log size

    or_st_time	disk_time;	// Wall-clock time according to disk
    or_st_time	disk_used;	// Time disk has been busy
    or_st_disk	disk_total;	// All operations combined
    or_st_disk	disk_mreads;	// Miscellaneous reads
    or_st_disk	disk_mwrites;	// Miscellaneous writes
    or_st_disk	disk_freads;	// Fetch reads
    or_st_disk	disk_ireads;	// Installation reads
    or_st_disk	disk_creads;	// Cleaner reads
    or_st_disk	disk_fwrites;	// Flusher writes
    or_st_disk	disk_cwrites;	// Cleaner writes

    ubits32	fetches;	// Number of fetches from server cache
    ubits32	misses;		// Number of misses in server cache
    ubits32	frag_writes;	// Number of fragments written out so far
    ubits32	frag_sizes;	// Total size of fragments written out so far
    ubits32	clean_count;	// Number of cleaned regions
    ubits32	clean_live;	// Amount of live data in cleaned regions

    bool encode(Network*) const;
    bool decode(Network*);
};

extern void sub_stats(or_stat& s, or_stat const& x);
// modifies	"s"
// effects	post(s) = pre(s) - x

extern void report_stats(FILE* f, or_stat const& s);
// effects	Report statistics from "s" to stream "f".

#endif /* _OR_STAT_H */
