/*
\section{Orefs}

This file contains the definition of Orefs.  An oref should be
considered opaque at the FE.  The structure given here is for use at
the OR.
*/

#ifndef _OREF_H
#define _OREF_H

#ifdef __cplusplus
extern "C" {
#endif

#include "common/bits.h"
#include "common/hashfuncs.h"

typedef ubits32 Oref;
#define OREF_CMP(a,b) ((a) - (b))
#define OREF_EQUAL(a,b) ((a) == (b))
#define OREF_LT(a,b) ((a) < (b))
#define OREF_GT(a,b) ((a) > (b))
#define OREF_LE(a,b) ((a) <= (b))
#define OREF_GE(a,b) ((a) >= (b))
#define OREF_HASH(a)    (hash_int(a))
#define OREF_SEGMENT(x) ((x) >> 16)
#define OREF_INDEX(x)   ((x) & 0xFFFF)
#define OREF_SET(o,s,i) (o = ((((ubits32) (s)) << 16) | (i)))

extern void sort_orefs(Oref* list, int n);
/*
 * modifies	"list[0..n-1]"
 * effects	Sorts the list contents in increasing order.
 */

#ifdef __cplusplus
}
#endif

#endif /* _OREF_H */
