#ifndef _PAGE_H
#define _PAGE_H

/* This is the unit sent from the OR to the FE when using
   page fetching.  This is only for the purpose of experimental
   comparison.  In particular, the paging version of Thor only
   works for read-only traversals where the transaction does not
   commit, because none of the code needed to send pages back to 
   the OR exists.
*/

#include "or_obj.h"

#define TRANSFERRED_PAGE_SIZE (6 * 1024)

#define PAGE_SLOTS TRANSFERRED_PAGE_SIZE / sizeof(OR_slot)

class Page {
 public:

   Page();  // an empty page with all slots zeroed

   OR_slot contents[PAGE_SLOTS];  // Note that rep is public

};

#endif /* _PAGE_H */
