#include <assert.h>
#include <math.h>
#include "samples.h"

void Samples::add_bunch(int n, double s, double ss) {
    num += n;
    total += (unsigned long) s;
    squared_total += ss;
}

double Samples::mean() {
    assert(num >= 1);
    return ((double) total) / ((double) num);
}

double Samples::stddev() {
    assert(num >= 2);

    double average = mean();
    double var = (squared_total/((double) num) - average*average);
    return sqrt(var);
}

void Samples::report(char const* n, FILE* stream) {
    switch (num) {
      case 0:
	fprintf(stream, "  %-18s: no samples\n", n);
	break;
      case 1:
	fprintf(stream,
		"  %-18s: samples= %u, mean= %2.2lf\n", n, num, mean());
	break;
      default:
	fprintf(stream,
		"  %-18s: samples= %u, mean= %2.2lf, stddev= %2.2lf\n",
		n, num, mean(), stddev());
	break;
    }
}

void Samples::delta(Samples* prev, char const* n, FILE* stream) {
    assert(prev->num <= num);
    unsigned long d_num, d_total;
    double d_mean, d_stddev, d_sqr;

    d_num = num - prev->num;

    switch (d_num) {
      case 0:
	fprintf(stream, "  %-18s: no samples\n", n);
	break;
      case 1:
        d_total = total - prev->total;
        d_mean = ((double) d_total) / ((double) d_num);
	fprintf(stream,
		"  %-18s: samples= %u, mean= %2.2lf\n", n, d_num, d_mean);
	break;
      default:
        d_total = total - prev->total;
        d_mean = ((double) d_total) / ((double) d_num);
        d_sqr = squared_total - prev->squared_total;
        d_stddev  = sqrt(d_sqr/((double) d_num) - d_mean*d_mean);

	fprintf(stream,
		"  %-18s: samples= %u, mean= %2.2lf, stddev= %2.2lf\n",
		n, d_num, d_mean, d_stddev);
	break;
    }
}
