// Speed tests for the hashed map

#include <iostream.h>
#include "common/map.h"

/* one of USE_HMAP, USE_MAP, USE_OPENMAP 
   should be defined.
*/
#if USE_HMAP

#define HMAP map
#define HKEY long
#define HVAL long
#define HCONTROL control

#include "common/hmap.h"

#endif

#if USE_MAP

#include "common/bhash.t"
#include "common/buckets.t"

class LongKey {
public:
    inline LongKey() : val(0) {} // need this for use with generators, annoyingly
    LongKey(long a) : val(a) {}
    inline void operator=(LongKey const &x) { val = x.val; }
    inline int hash() const { return val; }
    inline bool operator==(LongKey const &x) { return (x.val == val) ? TRUE : FALSE; }
    long val;
};

#define KEY LongKey
#define VALUE long
#include "common/stdhash.h"
#undef KEY
#undef VALUE

typedef Map<LongKey, long> map;
#endif

#if USE_OPENMAP
#include "common/openhashmap.h"

int hasher(long x) { return (unsigned(x)*1737350767U) & 0x7fffffff; }
bool longeq(long x, long y) { return (x == y)?TRUE:FALSE; }

declareOpenHashMap(map,long,long,hasher,longeq)
implementOpenHashMap(map,long,long,hasher,longeq)

#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <sys/time.h>

inline long rnd(int size) {
    return long(size * drand48());
}

class foo {};

main(int argc, char *argv[]) {
    map m(100);
    int size = 20000;
    int reps;
    int count = 0;
    if (argc < 2 || argc > 3) {
	fprintf(stderr, "Usage: %s <repetitions> [<size>]\n", argv[0]);
	exit(EXIT_FAILURE);
    }
    srand48(time(0));
    reps = atoi(argv[1]);
    if (argc == 3) size = atoi(argv[2]);
    for (long i = 0; i < reps; i++) {
	long j1 = i%size, j2 = size - j1, v;

#if USE_MAP || USE_OPENMAP
	m.store(j1, i);
#endif
#if USE_HMAP
	m.insert(j1, i);
#endif

#if USE_MAP
	m.remove(j2, v);
	if (0 == (i & 0xFF)) m.allowAutoResize();
#endif
#if USE_OPENMAP || USE_HMAP
	m.remove(j2);
#endif
    }
#if USE_MAP
    cout << "Efficiency: " << m.estimateEfficiency();
    cout << "\nClumping: " << m.estimateClumping() << "\n";
#endif
    return EXIT_SUCCESS;
}
