#include "common/transaction.h"
#include "common/Timer.h"
#include "common/network.h"
#include "common/unparser.h"
#include "common/ros.h"
#include "common/mos.h"
#include "common/nos.h"
#include "common/or_set.h"

Timer cumm_ros_send_timer, cumm_mos_send_timer, cumm_nos_send_timer;

bool Transaction::encode(Network* net) const {
    static bool printres = getenv("PRINT_TIME")? TRUE: FALSE;
    Timer timer;

    bool res1 = tid.encode(net) && net->send_ubits32(coordinator)
	&&  participants->encode(net);

    cumm_ros_send_timer.start();
    timer.reset(); timer.start();
    bool res2 = ros->encode(net);
    timer.stop(); float ros_time = timer.elapsed();
    cumm_ros_send_timer.stop();

    cumm_mos_send_timer.start();
    timer.reset(); timer.start();
    bool res3 = mos->encode(net);
    timer.stop(); float mos_time = timer.elapsed();
    cumm_mos_send_timer.stop();

    cumm_nos_send_timer.start();
    timer.reset(); timer.start();
    bool res4 = nos->encode(net);
    timer.stop(); float nos_time = timer.elapsed();
    cumm_nos_send_timer.stop();

    if (printres) {
	fprintf(stderr, "Ros = %9.5f, Mos = %9.5f, Nos = %9.5f\n",
		ros_time, mos_time, nos_time);
    }

    return res1 && res2 && res3;
}

bool Transaction::decode(Network* net) {
    return (tid.decode(net) &&
            net->recv_ubits32(&coordinator) &&
	    participants->decode(net) &&
	    ros->decode(net) &&
	    mos->decode(net) &&
	    nos->decode(net));
}

void Transaction::unparse (unparser* unp) {
    unp->print("Tx: ");
    tid.unparse(unp);
    unp->print("Coordinator = %d", coordinator);
    unp->newline();
    unp->print("Participants: ");
    participants->unparse(unp);
    unp->indent(4);
    ros->unparse(unp);
    mos->unparse(unp);
    nos->unparse(unp);
    unp->indent(-4);
}
