#ifndef _TRANSACTION_H
#define _TRANSACTION_H

/* This file contains the interface for transaction information transferred
   between the FE and the OR. A transaction object contains the ROS, MOS
   and the NOS.
*/

#include "common/tid.h"

class Mos;
class Nos;
class Ros;
class OR_set;
class Network;
class unparser;

class Transaction {
  public:
    Mos*  mos;
    Nos*  nos;
    Ros*  ros;
    Tid	  tid;
    ubits32 coordinator;   // OR number of coordinator, or 0 if transaction
                           // is read-only everywhere.
    OR_set* participants;  // OR numbers of participants

    bool encode(Network*) const;
    bool decode(Network*);
    void unparse(unparser*);
};

#endif /* _TRANSACTION_H */
