#include <stdio.h>
#include "device.h"
#include "tstamp.h"
#include "unparser.h"

#define MAX_COUNT   1000000     // Maximum value of the counter.
#define MICROSECS   1000000    // Each second has this many microseconds.
#define DIVN        (MAX_COUNT/MICROSECS)   // Division factor for microsecs.

Tstamp::Tstamp() {
}

Tstamp::Tstamp(ubits32 sec, ubits32 microsec) {
    
    seconds = sec;
    counter =  microsec/DIVN;
    // printf ("%d %d\n", time_.tv_sec, time_.tv_usec);
    // printf ("%d %d -- Time \n", seconds, counter);
    // printf ("%d %d -- Last \n ", lastissued.seconds, lastissued.counter);
}


Tstamp::Tstamp (Tstamp const& t) {
    seconds = t.seconds;
    counter = t.counter;
}

Tstamp Tstamp::operator+(bits32 increment) const {
    bits32 micro_secs;
    micro_secs = counter + increment;
    if (micro_secs >= 0)
	return Tstamp(seconds + micro_secs/MAX_COUNT, micro_secs % MAX_COUNT);
    // Negative case. microsecs is negative

    // We want ot subtract micro_secs time from this and return it
    int new_seconds = seconds - ((-micro_secs) + MAX_COUNT - 1) / MAX_COUNT;
    int new_micro_secs = (MAX_COUNT + micro_secs % MAX_COUNT) % MAX_COUNT;
    return Tstamp (new_seconds, new_micro_secs);
}

Tstamp Tstamp::next() const{
    ubits32 msecs;
    msecs = counter+1;
    if (msecs < MAX_COUNT) return Tstamp(seconds, msecs);
    // Increment the time and return. This has the danger of drifting 
    // away from real time, if the local tstamp is asked for too fast.
    return Tstamp(seconds+1, 0);
}

bool Tstamp::encode(Device* dev) const {
    return (dev->send_buffer(this, sizeof(Tstamp)));
}

bool Tstamp::decode(Device* dev) {
    return (dev->recv_buffer(this, sizeof(Tstamp)));
}

void Tstamp::unparse (unparser* unp) {
    unp->print("LTime: s = %-d, Us = %-d", seconds, counter);

//     un.blanks[un.indent] = 0;
//     fprintf(un.fp, "%sLTime: s = %-d, Us = %-d.\n", un.blanks, 
// 	    seconds, counter);
//     un.blanks[un.indent] = ' ';
}
