#include <stdio.h>
#include "tstamp.h"
#include "tstampgen.h"
#include "bits.h"
#include "other_unix.h"

Tstamp_Generator::Tstamp_Generator() : last_issued(0, 0) {
}

Tstamp Tstamp_Generator::generate() {
    struct timezone dummy;     // Ignoring the timezone information.
    struct timeval  time_;

    gettimeofday(&time_, &dummy);
    ubits32 sec = time_.tv_sec;  
    ubits32 usec = time_.tv_usec;

    Tstamp newts(sec, usec);
    if (!(newts > last_issued)) {
	// Have to generate something > "last_issued"
	newts = last_issued.next();
    }

    last_issued = newts;
    return newts;
}
