// \section{Generate New Timestamp}

#ifndef _TSTAMPGEN_H
#define _TSTAMPGEN_H

// A "Tstamp_Generator" generates a monotonically increasing
// series of time stamps.  No guarantees are made about time stamps
// generated by two different generators.
//
// If inside a multi-threaded program (such as the OR), the generator
// should be protected by a mutex that prevents concurrent access to
// the generator.

#include "tstamp.h"

class Tstamp_Generator {
  public:
    Tstamp_Generator();

    Tstamp generate();
    // effects	Returns a new time stamp that is greater than all
    //		time stamps generated so far by this object.
  private:
    Tstamp last_issued;
};

#endif /* _TSTAMPGEN_H */
