#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "unparser.h"

unparser::unparser(FILE *fp1){
    fp = fp1;
    if (!fp) fp = stderr;
    indent_ = 0;
    memset(blanks, ' ', 99);
    blanks[99]=blanks[0]=0;
}

unparser::~unparser() {
    if (fp != stderr) fclose (fp);
}

void unparser::print (const char* format, ...) {
    va_list ap;

    fprintf(fp, "%s", blanks);
    va_start (ap, format);
    vfprintf (fp, format, ap);
    va_end (ap);
}

void unparser::print_noblanks (const char* format, ...) {
    va_list ap;
    va_start (ap, format);
    vfprintf (fp, format, ap);
    va_end (ap);
}

void unparser::indent (int size) {
    // No error checking
    assert (indent_+size>=0);
    blanks[indent_] = ' ';
    blanks[indent_ + size] = 0;
    indent_ += size;
}

void unparser::newline() {
    fprintf(fp, "\n");
}
