// \section{Helper for Printing Objects}

#ifndef _UNPARSE_H
#define _UNPARSE_H

#include <stdio.h>

class unparser {
  public:
    unparser(FILE *fp);
    // Creates an unparse object that writes to this file.
    // If file is NULL, writes to stderr

    ~unparser();
    // Destructor. Closes the associated file if it is not stderr.

    void print(const char* format, ...);
    // Print the objects sent using format with indentation

    void print_noblanks(const char* format, ...);
    // Print the objects sent using format without indentation.

    void indent(int size);
    // Indent the printing of the later calls to print by size.
    // Negative size unindents.

    void newline();
    // Print a newline onto the unparser.

  private:
    FILE *fp;         /* The file into which the output has to be written */
    int  indent_;      /* Indent output by amount "indent_" */
    char blanks[100]; /* Blanks to be filled in this string  */
};

#endif /* _UNPARSE_H */
