###############################################################################
# Extra autoconf macros.

###############################################################################
# ACAUX_HAVE_PROTO
#
#	Search for a function prototypt.  If found, define
#	HAVE_<func_name>_PROTO.

AC_DEFUN(ACAUX_CHECK_PROTO,
[changequote(,)dnl
ac_tr_func=HAVE_`echo $1 | tr '[a-z]' '[A-Z]'`_PROTO
changequote([,])dnl
AC_MSG_CHECKING(for $1 prototype)
AC_CACHE_VAL(acaux_cv_proto_$1,[
AC_TRY_RUN([
#include <$2>
static void* ptr = &$1;
int main() {return 0;}
],acaux_cv_proto_$1=yes,acaux_cv_proto_$1=no,acaux_cv_proto_$1=no)])
AC_MSG_RESULT($acaux_cv_proto_$1)
if test "$acaux_cv_proto_$1" = "yes"; then
   AC_DEFINE_UNQUOTED(${ac_tr_func})
   fi])dnl

###############################################################################
# ACAUX_CXXDEFINCS
#
#	Search for C++ include files.  If found, set CXXDEFINCS to
#	a -I compiler specification for finding the include files.
#	If not found, set CXXDEFINCS to "".
#

AC_DEFUN(ACAUX_CXXDEFINCS,
[AC_MSG_CHECKING(for "$CXX" include files)
if test -z "$CXXDEFINCS"; then
  echo "#include <iostream.h>" > conftest.cc
  CXXOUTPUT=`$CXX -E conftest.cc | egrep '^#.*/iostream.h' 2> /dev/null`
  CXXDIR=`expr match "$CXXOUTPUT" '#[0-9 ]*"\([^ ]*\)/iostream.h'`
  if test -z "$CXXDIR"; then
     CXXDIR=`expr match "$CXXOUTPUT" '#line [0-9 ]*"\([^ ]*\)/iostream.h'`
  fi
  if test -f "$CXXDIR"/iostream.h ; then
    CXXDEFINCS=-I"$CXXDIR"
  fi
  rm -f conftest*
fi
AC_MSG_RESULT("$CXXDEFINCS")
AC_SUBST(CXXDEFINCS)])

###############################################################################
# Find path name for specified library
#
# ACAUX_LIB_FINDPATH(<name>)
#
#	Look for specified library.  If the library is not found, print
#	an error message and exit.  Otherwise, define the variable
#	<name>lib to be a linker specification for finding the specified
#	library.
#
# Example -
#
#	ACAUX_LIB_FINDPATH(tcl)
#
#     If the tcl library is in /usr/local/lib, then the preceding macro
#     will set the variable "tcllib" to "-L/usr/local/lib".

AC_DEFUN(ACAUX_LIB_FINDPATH,[
if test -z "[$]$1[lib]"; then
  echo checking for $1 library
  $1[lib]=nope
  for d in /usr/local/lib /usr/lib; do
    if test -f "$d/lib$1.a"; then
      $1[lib]=$d
      break
    fi
    if test -f "$d/lib$1.so"; then
      $1[lib]=$d
      break
    fi
    if test -f "$d/lib$1.so.*"; then
      $1[lib]=$d
      break
    fi
  done
  if test "[$]$1[lib]" = nope; then
    cat << EOM
I could not find the $1 library.  Please set the environment variable
$1[lib] to the directory that contains the library and rerun configure.
EOM
    exit 1
  fi
fi
# Plug -L in front of it
$1[lib]="-L$[$1][lib]"
test -n "$verbose" && echo "	setting $1[lib] to [$]$1[lib]"
AC_SUBST($1[lib])])dnl

###############################################################################
# Find path for specified include file
#
# ACAUX_INC_FINDPATH(<var>,<header>)
#
#	Look for specified header file.  If it is not found, print
#	an error message and exit.  Otherwise, define the variable
#	<var> to be a compiler specification for the specified header file.
#
# Example -
#
#	ACAUX_INC_FINDPATH(tclinc,tcl.h)
#
#     If tcl.h is in /usr/local/include, then the preceding macro
#     will set the variable "tclinc" to "-I/usr/local/include".

AC_DEFUN(ACAUX_INC_FINDPATH,[
if test -z "$[$1]"; then
  echo checking for include file $2
  $1=nope
  for d in /usr/local/include /usr/include; do
    if test -f "$d/$2"; then
      $1=$d
      break
    fi
  done
  if test "[$]$1" = nope; then
    cat << EOM
I could not find include file $2.  Please set the environment variable
$1 to the directory that contains the include file and rerun configure.
EOM
    exit 1
  fi
  if test "[$]$1" = "/usr/include"; then
    # Never put /usr/include in explicitly
    $1=
  fi
fi
# Plug -I in front of it
if test -n "$[$1]"; then
  $1="-I$[$1]"
fi
test -n "$verbose" && echo "	setting $1 to [$]$1"
AC_SUBST($1)])dnl
