#ifndef _LEX_INPUT_H
#define _LEX_INPUT_H

#ifdef __cplusplus
extern "C" {
#endif

#undef input
#undef output
#undef unput

#define input() lex_input()
#define output(c) assert(0)
#define unput(c) lex_unput(c)

extern char lex_input();
extern void lex_unput(char);
    /* Called from within LEX */

extern void start_lex_input(char (*prim_input)(), int *lineno);
    /* Called from user to specify where input should come from.
       Only one user is allowed at one time; "finish_lex_input"
       must be called to release the resource. */

extern void finish_lex_input();
    /* See above. */

#ifdef __cplusplus
}
#endif

#endif /* _LEX_INPUT_H */
