%{
#include "common/basic.h"
#include "types/str.h"
#include "types/list.h"
#include "types/vec_def.h"
#include "types/type_def.h"
#include "types/method.h"
#include "types/objtype_class.h"
#include "ti_grammar.h"
#include "lex_input.h"
#include <limits.h>
#include <string.h>

string yydocomment();
bool yyhandleDirective();

char yyfname[PATH_MAX];

#define text ((char *)yytext)

%}

letter [A-Za-z]
special [_]
S [ \t\r]
digit [0-9]
id (({letter}|{special})({letter}|{digit}|{special})*!?)
handle (#{intstr})
dot (\.)

%%

{S}+            ;
"# "           { if (!yyhandleDirective()) return LexErr; }
"\n"		{ yylineno++; }
"("		{ return LPAREN; }
")"		{ return RPAREN; }
","		{ return COMMA; }
"end"           { return END; }
"returns"       { return RETURNS; }
"yields"        { return YIELDS; }
"type"          { return TYPE; }
"inherits"      { return INHERITS; }
"class"		{ return CLASS; }
"signals"       { return SIGNALS; }
"["		{ return LBRACK; }
"]"		{ return RBRACK; }
"has"		{ return HAS; }
"where"		{ return WHERE; }
"SPECIAL"       { return SPECIAL; }
"VISIBLE"       { return VISIBLE; }
"extension"     { return EXTENSION; }
":"		{ return COLON; }
{id}            { yylval.s = string_new(text); return Id; }
"%"	        { yylval.s = yydocomment(); return Comment; }
"="             { return EQ; }
".."           { return DOTDOT; }
.		{ return LexErr; }

%%

#include "types/textwr.h"

string yydocomment()
{
   textwr tw = textwr_new();
   wr w = textwr_as_wr(tw);
   char c;
   loop {
      c = input();
      if (c == '\n' || c == 0) {
        yylineno++;
        wr_close(w);
	return textwr_toString(tw);
      }
      wr_putChar(w, c);
   }
}

int yywrap()
{
    return TRUE;
}

yyerror(char *msg)
{
    fprintf(stderr, "Error: \"%s\", line %d: %s\n", yyfname, yylineno, msg);
}

bool yyhandleDirective()
{
    char buf[512];
    char c;
    char *s = buf;
    int firstq, flen;
    while ('\n' != (c = input())) {
	if (!c) return FALSE;
	*s++ = c;
    }
    *s = 0;
    if (0 == sscanf(buf, "%d ", &yylineno)) return FALSE;
    firstq = strcspn(buf, "\"") + 1;
    flen = strcspn(&buf[firstq], "\"");
    strncpy(yyfname, &buf[firstq], flen);
    yyfname[flen] = 0;
    return TRUE;
}
