/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _CACHE_FETCH_H
#define _CACHE_FETCH_H

#ifdef __cplusplus
extern "C" {
#endif

#include "runtime/obj.h"
#include "runtime/surr_def.h"

struct prefetch_hint;

/* See cache.h for the other operations on the FE cache.
   The cache_fetch operation is widely used, so it's separated
   into this file on its own. 
*/

obj cache_fetch (surr s, struct prefetch_hint* h);
    /* effects - return the object corresponding to "s", fetching it into
	         the cache if necessary.  The hint "h" suggests how to 
                 fetch the object and perhaps some related objects.  
		 The object returned is fully swizzled and can 
		 immediately be used by the runtime code support.
       errors - returns zero if no object corresponds to surrogate "s".
    */

obj cache_fetch_pointer (obj s, struct prefetch_hint* h);
    /* effects - as with cache_fetch, but "s" is a marked pointer
                 instead of a pointer to a surrogate.
       errors - returns zero if no object corresponds to "s".
    */

#ifdef __cplusplus
}
#endif

#endif /* _CACHE_FETCH_H */
