/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _CACHE_INTERNAL_H
#define _CACHE_INTERNAL_H

#include "cacheval.h"
#include "types/type_def.h"
#include <stddef.h>
#include "config/vdefs/PAGING.h"

/* Routines and definitions usable within cache code but
   invisible outside. */

extern cacheval* cache_prim_alloc(size_t size);

extern obj cache_create_surrogate (Xref x, objtype t);

extern int cache_occupied_slots(); 

#if PAGING
#include "common/page.h"
extern Page* pcache[];
extern int numpages;

extern int cache_find_empty_page(int segnum);
#endif

#endif /* _CACHE_INTERNAL_H */

