/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _CACHEVAL_H
#define _CACHEVAL_H

#include "common/bits.h"
#include "common/or_obj.h"
#include "common/oref.h"
#include "common/xref.h"
#include "runtime/value.h"

/* What can be in a 64-bit slot in the cache: */

typedef union {

  /* One narrow (32-bit) field: */

  bits32  integer;	/* Integer value */

  /* One wide (64-bit) field: */

  OR_uid  uid;		/* Object uid */
  char	  chars[8];	/* Packed characters */
  Xref    xref;         /* reference to remote object */

  /* One field of machine-dependent width, no larger than 64 bits: */

  void *  vm_addr;      /* Memory address */
  fevalue fev;          /* Format palatable to FE runtime */

  /* Two fields, each 32 bits: */

  struct {
    bits32 value1;
    bits32 value2;
  } pair;

} cacheval;


#endif /* _CACHEVAL_H */

