/* Copyright Barbara Liskov, MIT 1996 */

/* Debugging */

#if DEBUG_CACHE

void print_class(Xref class_xref) {
  if ((class_xref.or == WK_OR) && (OREF_SEGMENT(class_xref.oref) == 0)) {
    /* A well-known class */
    switch (OREF_INDEX(class_xref.oref)) {
    case WK_Type_OREF: printf("type");
      break;
    case WK_Any_OREF: printf("any");
      break;
    case WK_Int_OREF: printf("int");
      break;
    case WK_Bool_OREF: printf("bool");
      break;
    case WK_Char_OREF: printf("char");
      break;
    case WK_String_OREF: printf("string");
      break;
    case WK_Float_OREF: printf("float");
      break;
    case WK_Null_OREF: printf("null");
      break;
    case WK_Method_OREF: printf("method");
      break;
    case WK_List_OREF: printf("list");
      break;
    case WK_Wr_OREF: printf("wr");
	break;
    case WK_TextWr_OREF: printf("TextWr");
	break;
    case WK_Formal_OREF: printf("formal");
      break;
    case WK_Signal_OREF: printf("signal");
      break;
    case WK_Param_OREF: printf("param");
      break;
    case WK_Class_OREF: printf("class");
      break;
    case WK_Instn_OREF: printf("instn");
      break;
    case WK_PType_OREF: printf("ptype");
      break;
    case WK_PClass_OREF: printf("pclass");
      break;
    case WK_ClassInstn_OREF: printf("classinstn");
      break;
    case WK_FullList_OREF: printf("fulllist");
      break;
    case WK_EmptyList_OREF: printf("emptylist");
      break;
    default: printf("Unknown 'well-known' class: %x", OREF_INDEX(class_xref.oref));
	break;
    }
  }
  else
    printf("class xref: OR: %x segment: %x index: %x",
	   class_xref.or,
	   OREF_SEGMENT(class_xref.oref),
	   OREF_INDEX(class_xref.oref));
}

void print_bitfield(Obj_bitfield bf) {
  switch (bf) {
  case OBJ_BF_ALLDATA:
    printf("all data");
    break;
  case OBJ_BF_ALLREFS:
    printf("all refs");
    break;
  case OBJ_BF_LONG_BF:
    printf("long bitfield"); /* XXX finish implementation */
    break;
  default:
    printf("bitfield: %8x", bf);
    break;
  }
}

void print_real_or_obj(void *start) {
  OR_obj *oro = (OR_obj *)start;
  printf("nulls: %d\n", OR_OBJ_DSPACE(oro));
  print_class(OR_OBJ_CLASS(oro));
  printf("\n");
  int objsize = OR_OBJ_SIZE(oro);
  printf("size: %d ", objsize);
  print_bitfield(OR_OBJ_BITFIELD(oro));
  printf("\n");
  printf((objsize > 0) ? "field" : "");
  printf((objsize > 1) ? "s" : "");
  printf((objsize > 0) ? ":\n" : "");
  cacheval *userslot = (cacheval *) oro->slot;
  int i;
  for (i = 0; i < objsize; i++) {
    printf("%16lx\n", *userslot);
    userslot++;
  }
}

void print_or_obj(void* point, int nulls) {
  /* print an OR_obj.  Skip /nulls/ slots before interpreting header. */
  cacheval *base = (cacheval *)point;
  printf("%d null field", nulls);
  printf((nulls != 1) ? "s" : "");  /* handle plural correctly */  
  printf((nulls != 0) ? ":" : "");  /* handle nothing correctly */
  printf("\n");
  int i;
  for (i = 0; i < nulls; i++) {
    printf("%16lx\n", *(base + i));
  }
  print_real_or_obj(base + i);
}

void print_or_obj_from_descs(cacheval* chunk, or_objdesc* descs, int index) {
  /* print an OR_obj when the descriptors are available */
  int i;
  int totalfields = 0;
  if (index >= 0) {
    for (i = 0; i < index; i++) {
      totalfields += descs[i].nullspace;
      totalfields += descs[i].objsize;
    }
    cacheval *base = chunk + totalfields;
    int nulls = descs[index].nullspace;
    print_or_obj(base, nulls);
  }
  else
    printf("Bad index\n");
}

void print_stuffed_or_obj(void* chunk) {
  /* print an OR_obj with the number of nulls in the first word */
  cacheval *x = (cacheval *)chunk;
  print_or_obj(x, x->integer);
}

#endif /* DEBUG_CACHE */
