/* Copyright Barbara Liskov, MIT 1996 */

#include "gc_register.h"
#include "gc_init.h"
#include "cache.h"
#include "boot/specs.h"
#include "types/stdlist.h"

void gc_init() {
  // Initialize everything except the_empty_list, which should have
  // already been registered.

    for (int i = 0; builtinObjs[i].name; i++) {
	obj * bi = builtinObjs[i].object;
	if (bi != (obj *)&the_empty_list) {
	    if (obj_in_heap(*bi))
		gc_register_root(bi);
            else
		gc_register_meta_root(bi);
	}
    }
}


