/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _INDIRECT_TABLE_H
#define _INDIRECT_TABLE_H

#include "cacheval.h"
#include "common/th_assert.h"
#include "config/vdefs/PAGING.h"
#include "config/vdefs/INDIRECTION.h"

/* This macro returns the actual pointer to the object
   In indirection it just dereferences the pointer
*/
#if INDIRECTION
#define ACTUAL_POINTER(x) ((obj) (* ((long *)x)))
#define ACTUAL_ANY_POINTER(x) ((any) (* ((long *)x)))
#else
#define ACTUAL_POINTER(x) ((obj) x)
#define ACTUAL_ANY_POINTER(x) ((any) x)
#endif

/* If there is no indirection, this is a nop (and returns x otherwise,
   this procedure adds the object to the indirect table and returns a
   pointer to the entry in the indirect table
   */

#if INDIRECTION
extern obj get_indirect_storable_pointer(obj x);

#define get_storable_pointer(x) \
        get_indirect_storable_pointer(x)
#else
#define get_storable_pointer(x) (x)
#endif



#endif /* _INDIRECT_TABLE_H */
