/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _CACHEVAL_H
#define _CACHEVAL_H

#include "common/bits.h"
#include "common/oref.h"
#include "common/xref.h"

/* A limited version of cacheval.h for converting between
   xrefs and memory pointers (e.g. objs).
   Keep this in sync with cacheval.h  */

typedef union {

  /* One wide (64-bit) field: */
  Xref    xref;         /* reference to remote object */

  /* One field of machine-dependent width, no larger than 64 bits: */
  void *  vm_addr;      /* Memory address */

} local_cacheval;


#endif /* _CACHEVAL_H */

