/* Copyright Barbara Liskov, MIT 1996 */

#include "common/basic.h"

#include "fe/cache/cacheval.h"
#include "fe/cache/region.h"

Region::Region() {
  low = 0;
  high = 0;
}

Region::~Region() {}

Region::Region(cacheval *lowbound, cacheval *highbound) {
  if (lowbound <= highbound) {
    low = lowbound;
    high = highbound;
  }
  else {
    low = highbound;
    high = lowbound;
  }
}

int Region::bytesize() {
  return ((char *)high - (char *)low);
}

int Region::slotsize() {
  return (high - low);
}

//bool Region::overlap(Region r) {
//  return ((low <= r->low) && (high > r->low)) || 
//         ((high >= r->high) && (low < r->high));
//}

