/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _REGION_H
#define _REGION_H

#include "cacheval.h"
#include "common/basic.h"

// A Region is a contiguous piece of cache storage.  Regions may
// contain Thor objects, but are not Thor objects themselves.

class Region {
 public: 
     Region();
     // default constructor; meaningless but helps typechecking in 
     // some places.

     Region(cacheval *lowbound, cacheval *highbound);
     // return new region.  Still works even if lowbound > highbound.

     ~Region();
     // destroy region

     int bytesize();
     // return number of bytes in region.

     int slotsize();
     // return number of slots in region.

//     bool overlap(Region r);
     // Does this region have any byte in common with region r?

 private:
     cacheval *low;
     cacheval *high;
};

#endif /* _REGION_H */
