/* Copyright Barbara Liskov, MIT 1996 */



//
// FIFO of subpages prefetched from the OR.
//

#include "subpage_fifo.h"


void 
SubpageFIFO::insert (OR_num o, int num, or_obj_descriptors *d) {
  // Requires: d has num elements
  // Effects: Initialize a subpage descriptor using o, num and d
  //          and inserts it in the subpage FIFO.
  Subpage *s = new Subpage;
  s->or_num = o;
  s->num = num;
  s->descs = d;
  Link *l = new Link;
  l->value = (void *) s;
  head.append(l);
  fifo_size++;
}

void 
SubpageFIFO::insert (Subpage *s) {
  // Requires: s is a properly initialized subpage
  // Effects: Inserts the  subpage descriptor in the subpage FIFO.
  Link *l = new Link;
  l->value = (void *) s;
  head.append(l);
  fifo_size++;
}


Subpage *
SubpageFIFO::remove_first(void) {
  // Effects: removes the first element from the subpage FIFO and
  //          returns it. If the FIFO is empty it returns null.
  Link *l = head.prev();
  if (l == &head)
    return 0; 
  l->remove();
  fifo_size--;
  Subpage *s = (Subpage *)l->value;
  delete l;
  return s;
}
