/* Copyright Barbara Liskov, MIT 1996 */

//
// FIFO of subpages prefetched from the OR.
//


#ifndef _SUBPAGEFIFO_H
#define _SUBPAGEFIFO_H

#include "common/fe_or_msg.h"
#include "common/link.h"

struct Subpage {
	OR_num or_num;
	or_obj_descriptors *descs;
	int num;

	Subpage(void) {
		or_num = 0;
		descs = 0;
		num = 0;
	}

	~Subpage(void) {
		if (descs)
			delete descs;
	}
};


class SubpageFIFO {
	Link head;
        int fifo_size;

public:

	SubpageFIFO(void) { fifo_size = 0;}
	void insert (OR_num o, int num, or_obj_descriptors *d);
	// Requires: d has num elements
        // Effects: Initialize a subpage descriptor using o, num and d
        //          and inserts it in the subpage FIFO.
    
	void insert (Subpage *s);
	// Requires: s is a properly initialized subpage
	// Effects: Inserts the  subpage descriptor in the subpage FIFO.
  

	Subpage *remove_first(void);
	// Effects: removes the first element from the subpage FIFO and
        //          returns it. If the FIFO is empty it returns null.
  
	int size(void) const {return fifo_size;}
        // Effects: returns the numer of elements in the subpage FIFO

};
		

#endif //_SUBPAGE_H
