/* Copyright Barbara Liskov, MIT 1996 */

#ifndef _SWIZ_H
#define _SWIZ_H

#include "common/fe_or_msg.h"
#include "common/xref.h"
#include "common/network.h"

#include "fe/types/type_def.h"
#include "fe/runtime/obj.h"
#include "fe/cache/cacheval.h"
#include "fe/cache/subpage_fifo.h"

extern SubpageFIFO subpage_fifo;

#include "config/vdefs/PAGING.h"

class OR_obj;

void init_swiz();
  /* effects - initializes swiz data structures.  Must be called before
               any other routines in this interface.  The FE configuration
               is used as a global variable (passed implicitly).
  */

void cache_enter_fetched_objects(Network *net, int num, OR_num or_num,
					 or_objdesc* desc);
// requires	num is the number of objects in desc, all of these
//              were fetched from OR or_num and desc points to the objects
//              and contains their orefs, net is the network object where
//              the fetch reply was received.
//
// effects	Inserts the objects in descs in the cache if they
//              are not there already.

void enter_nobj_info (obj nobj, Xref x);
 /*
   effects - enters the new object information in the swizzle table.
  */

void cache_swizzle_object(int or_num, obj unswiz);
// requires	Object is unswizzled. "unswiz" points to very beginning
//		of the cached object.  Object was fetched from specified
//		OR.
// effects	Fully unswizzle the object, in place.

void cache_prim_swizzle (obj unswiz, int or_num, OR_obj *or_rep, class_ c);
  /* effects - fully swizzle the object unswiz, in place. 

     The pointer /unswiz/ actually points into the nulls left at the
     beginning of the object for the future dispatch header. 
     "or_rep" points to the beginning of the embedded "OR_obj".
     "c" gives the class of the object (note that the class field in the
     "OR_obj" might have been overwritten, hence the class cannot be
     derived from there).
  */

void rebuild_swiztab();
  /* requires - called by garbage collector exactly once for each
                collection, after all objects that will be moved 
                have been moved.
     effects - uses cache_forwarded to update the swizzle table to 
               reflect the new locations of objects.
  */

obj swiz_get_snap(Xref x);
  /* requires: x is present in the swizzle table
     effects - returns the address of the real (non-surrogate) version
               of x in the cache, if any.  If there is none, returns 0.
  */

obj swiz_get_object(Xref x);
  /* effects - returns the address of the real (non-surrogate) version
               of x in the cache, if any.  If there is none, returns 0.
	       This is essentially same as swiz_get_snap but without the
	       requires clause
  */

void shrink_objects();
  /* effects - shrinks some number of objects in the cache.  Used to
               make progress when the garbage collector is starting 
               to thrash.
  */

void swiz_check_table(bool mark, int print_level);


void clear_swiztab(void);
  /* effects - clear the swizzle table */

#if PAGING
obj cache_swizzle_page(int pagenum, Xref ref);
  /* effects - processes the indicated page so that each reference
               on that page is converted to a direct memory pointer
               if it refers to an in-cache object.  Return the object
               corresponding to "ref", or 0 if that object is not on 
               this page.
  */
#endif

#endif /* _SWIZ_H */
