/*  Copyright 1995 Barbara Liskov */

#ifndef _BINARY_INTERFACE_H
#define _BINARY_INTERFACE_H

/* Currently assumes the same architecture for the FE and the client.
This assumption will usually be true because FE's and clients often
run on the same machine.

The binary interface is modeled closely after the ASCII interface but
requires very little parsing.  At the same time, I have tried to
maintain enough redundancy in the encoding that is possible to
resynchronize after errors.

For the socket case, a size field indicating the message size of the client
command is also sent. See sever.c file to see how it is handled

The following are the encodings for the FE commands (The brackets,
spaces, and braces are all metasyntactic characters, not part of
the encoding!):

Futures:   F			-- send all future-handle mappings 
FreeHandle:H<Num:Int><handle1:Int><Handle2:Int> .......
Invoke:	   I<self: Val><method: Int>[<arg0:Val> ...]\n
FInvoke:   J<self: Val><method: Int>[<arg0:Val> ...][<future0:Int>...]\n
PInvoke:   K<self: Val><method: Int>[<arg0:Val> ...][<future0:Int>...]\n
Lookup:	   L<type: String><method_index:integer>
Input:	   N<s: String>		-- read a string, return its handle 
Print: 	   P<p: Val>		
Resync:    R                    -- Client to FE channel resynchronized 
New_cell:  U                    -- create a new cell and return a handle
FNew_cell: V<future:Int>        -- create a new cell and map it to future
Wellknown: W<name: String>	-- lookup the given wellknown object

XXX Other stuff used by promises code but not documented:
	D, E, M, X
(The following used inside control structures?)
	f, g, h, l, m, x, y, r

where <name: T> represents the encoding for an of type T and [<x>...]
represent 0 or more repetitions of <x>.  Here are the encodings for
various kinds of data:

Val:	   i<Int>  
           h<Handle>
           c<Char>    	
	   b<Bool>
 	   r<Real>
	   n			# null 
	   s<String>
	   
Int:  	   <byte0>..<byte3>, in machine order
Handle:	   <byte0>..<byte3>, in machine order
Char:      <byte0>
Bool:	   \000 (for false) or \001 (for true)
Real:	   <machine encoding>
Null:	   n
String:    <length: Integer><char0>..<char_{N-1}>\0
             where the integer give the length (including 
             the terminating null byte at the end of the string)

The encodings for the return values are as follows:

Futures:		=<return_cnt:Int>[<future1:Int><handle1:Int>...]

Successful method	=<h:handle>
lookup
Failed method		!
lookup

Successful Input:	=<h:handle>
Failed Input:		!

Successful Invoke:	=[<result1:Val>...]
Failed Invoke:		!<exception:string>[<result1:Val>...]

PInvoke:		(nothing returned, results mapped to given futures)

Successful Wellknown:	=<result:Val>
Failed Wellknown:	!

Quit:			=
*/

#include "fe/runtime/obj.h"
#include "common/basic.h"
#include "config/vdefs/SHM.h"
#include "config/vdefs/PROMISES.h"
#include <stdio.h>

#if !SHM
#include "server.h"
#else
#include "shm_macros.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

    void binaryDispatch(connection c, obj env, FILE *f);
    bool binarySingleOp(connection c, obj env, FILE *f);
    void initDispatch();
#ifdef __cplusplus
}
#endif

#define MAX_ARGS  16
/*  Maximum number of arguments to a method invocation  */

#endif /* _BINARY_INTERFACE_H */
