/*  Copyright 1995 Barbara Liskov */

#ifndef _CONTROL_STRUCTURES_H
#define _CONTROL_STRUCTURES_H

#include "common/basic.h"
#include "parse_tree.h"
#include "type_check.h"
#include "runtime/except.h"
#include <stdlib.h>

#include "config/vdefs/SHM.h"

#if !SHM
#include "server.h"
#else
#include "shm_macros.h"
#endif

extern int  control_level;

extern exception control_exc;
extern void* control_exc_value;

bool begin_control(connection c);

bool end_control(connection c);

bool add_method_node(MethodNode *);

void control_invoke(connection c);

#endif /* _CONTROL_STRUCTURES_H */

