// Copyright 1995 Barbara Liskov

#include "gen-include.h"
#include "gen-C-veneer.h"
#include "gen-binary-C-veneer.h"
#include "gen-C++-veneer.h"
#include "gen-Erlang-veneer.h"
#include "gen-m3-veneer.h"
#include "dump.h"
#include "boot/type_init.h"
#include "types/any.h"
#include "types/dict.h"
#include "types/class_class.h"
#include "types/class.h"
#include "types/vec.h"
#include "types/string_class.h"
#include "types/wr.h"
#include "types/textwr.h"
#include "common/fail.h"
#include "common/compat.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>


// Dictionary of fully instantiated types.
dict inst_typeEnv;

extern void make_Cxx_veneer_inst_types(dict inst_typeEnv);

void do_dump(void *env, string key) {
    dict d = (dict)env;
    any a = dict_fetch(d, key);
    objtype t = UNPV(objtype, obj_as_type(any_get_obj(a)));
    make_includes(t);
}

void fe_dump(int src, dict typeEnv) {
    struct stat st;
    if (fstat(src, &st) != 0) {
	perror("checking size of source file");
	exit(EXIT_FAILURE);
    }
    char *contents = new char[st.st_size];
    if (read(src, contents, st.st_size) != st.st_size) {
	perror("reading source file");
	exit(EXIT_FAILURE);
    }
    dict newTypes = processTypeSpecs(contents, typeEnv);
    struct closure cl;
    cl.f = (ifunc)do_dump;
    cl.env = newTypes;
    dict_keys(newTypes, cl);
    delete_dict(newTypes);
}

// dump_env is used by do_veneer dump

struct dump_env {
    char *language;
    dict typeEnv;

    dump_env(char *lang, dict tEnv) {
	language = lang;
	typeEnv = tEnv;
    }
};

#define match(x, y)  (strcmp(x, y)==0)

void do_veneer_dump(struct dump_env *env, string key)
{
    dict d = env->typeEnv;
    any a = dict_fetch(d, key);
    int kind = type_kind((type)a);
    objtype t = UNPV(objtype, any_get_obj(a));
    
//    printf("dumping %s\n", string_charp(key));

    if (kind == CLASS_INSTN_KIND) {
      /* Output pragma for template */
      FILE *pragmalist;
      if (pragmalist = fopen("_th-pragmalist.h", "a")) {
printf("#pragma define_template ");
	fprintf(pragmalist, "#pragma define_template ");
printf("%s\n", string_charp(t->name));
	fprintf(pragmalist, "%s\n", string_charp(t->name));
	fclose(pragmalist);
      } else {
printf("Failed to open _th-pragmalist.h\n");
      }
    }

    if ((kind == CLASS_KIND) || (kind == CLASS_INSTN_KIND)) {
      if (! objtype_as_class(t)->visible) {
//	printf("not dumping %s\n", string_charp(key));
	return;	/* Don't make veneers for non-visible classes */
      }
    }
    // Removed 5/22/95 dwc: need these .h files...
    // if (vec_length(t->methods_) > 0) {
	if ((!env->language) || match(env->language, "C-binary"))
	    make_binary_C_veneer_files(t);
	else if (match(env->language, "C-ascii"))
	    make_C_veneer_files(t); 
	else if (match(env->language, "C++")) {
	    make_Cxx_veneer_files(t);
	} else if (match(env->language, "Erlang")) {
	    make_Erlang_veneer_files(t);
        } else if (match(env->language, "m3")) {
	    make_m3_veneer_files(t);
        } 
	else {
	    exc = &exc_not_possible;
	    exc_value = "Unknown language";
	    return;
	}
    // }
}


bool veneer_dump(char *srcfile, dict typeEnv, char *language)
/*
  Create a veneer interface for the types in srcfile for language.
  If srcfile="builtins" or "specs.th", generate veneer interfaces for all
  builtin types.

  Currently supported languages are
   - "C-binary" (the default, a C veneer for the binary interface to the FE) 
   - "C-ascii"  (a C veneer for the ascii interface to the FE)
   - "C++"      (a C++ veneer)

   Return FALSE is the srcfile is not found or if language is not supported.
*/
{
  int src;
  struct stat st;


  if (match(srcfile, "builtins") || match(srcfile, "specs.th")) {
      // dump the built-in types

      inst_typeEnv = dict_new();

      dump_env e = dump_env(language, typeEnv);
      struct closure cl = {(ifunc) do_veneer_dump, &e};
      if (language && match(language, "m3")) open_m3_veneer_files("Builtins");

      dict_keys(typeEnv, cl);

      if (language && match(language, "m3")) close_m3_veneer_files();
      if (exc && exc_value) {
	  printf("Error: %s\n", exc_value); 
	  return FALSE;
      }

      if (language && match(language, "C++"))
	make_Cxx_veneer_inst_types(inst_typeEnv);

      return TRUE;
    }

  else {			// dump the types in srcfile
    if ((src = open(srcfile, O_RDONLY)) == -1) {
      perror("opening Theta source file");
      return FALSE;
    }

    if (fstat(src, &st) != 0) {
      perror("checking size of source file");
      return FALSE;
    }

    char *contents = new char[st.st_size];
    if (read(src, contents, st.st_size) != st.st_size) {
      perror("reading source file");
      return FALSE;
    }

    dict newTypes = processTypeSpecs(contents, typeEnv);
    dump_env e = dump_env(language, newTypes);
    struct closure cl = {(ifunc) do_veneer_dump, &e};
    dict_keys(newTypes, cl);
    CATCH {printf("Error: %s\n", exc_value);}
    delete_dict(newTypes);
    free(contents);
    return TRUE;
  }
}




