/*  Copyright 1995 Barbara Liskov */

#ifndef _DUMP_H
#define _DUMP_H

#include "types/dict.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void fe_dump(int src, dict typeEnv);
/* read a Theta type definition from fd src and dump .h and .c files.
*  typeEnv should be the type environment returned by initializing
*  the built-in types.
*/

extern bool veneer_dump(char *srcfile, dict typeEnv, char *language);
/* 
  Create a veneer interface for the types in srcfile for language.
  typeEnv should be the type environment returned by initializing If
  srcfile="builtins" or "specs.th", generate veneer interfaces for all
  of the builtin types.

  Currently supported languages are
   - "C-binary" (the default, a C veneer for the binary interface to the FE) 
   - "C-ascii" (a C veneer for the ascii interface to the FE)
   - "C++" (a C++ veneer for the binary interface to the FE)
   - "Erlang" (an Erlang veneer for the binary interface to the FE)

   Return FALSE is the srcfile is not found or if language is not supported.
*/   

#ifdef __cplusplus
}
#endif

#endif /* _DUMP_H */

