// Copyright 1995 Barbara Liskov

#include "fast_invoke.h"
#include "runtime/obj_class.h"
#include "runtime/alloc.h"
#include "types/type.h"
#include "types/method.h"
#include "types/string_class.h"
#include "types/class_class.h"
#include "types/int.h"
#include "types/char.h"
#include "types/real.h"
#include "types/any.h"
#include "types/str.h"
#include "types/objtype_class.h"
#include "common/th_assert.h"
#include "common/fail.h"
#include "types/vec_instns.h"
#include "cache/gc_register.h"
#include "types/vec_class.h"
#include <stdlib.h>

exceptional_return last_invoke_exception;

vec /* [type] */ method_get_signal(method m, string name)
{
    int num_sigs = vec_length(m->signals);
    signal_ *sigs = UNPV(signal_ *, vec_items(m->signals));
    int i;
    for (i = 0; i < num_sigs; i++) {
	if (string_equal(name, sigs[i]->name)) return sigs[i]->returns;
    }
    return 0;
}

vec /* [type] */ get_exc_types(method m)
{
    if (exc == &exc_failure) {
	vec v = make_vec_Type(1, TRUE);
	vec_store(v, 0, PV(String));
	return v;
    }
    if (exc == &exc_abort) {
	vec v = make_vec_Type(0, TRUE);
	return v;
    } else 
	return method_get_signal(m, exc->name);
}


#ifndef NDEBUG
static void printExcError(type t, method m)
{
    fail("FATAL ERROR\n"
	 "Method %.50s.%.50s raised the unexpected"
	 " exception %.50s",
	 string_charp(type_name(t)),
	 string_charp(method_name(m)),
	 (exc->name));
}
#endif
