/*  Copyright 1995 Barbara Liskov */

#ifndef _FAST_INVOKE_H
#define _FAST_INVOKE_H

#include "common/fail.h"
/* Overview:

"fast_invoke.h" is designed to minimize the amount of heap allocation
and copying required for an invoke; virtually all methods will require
no heap allocations (garbage collected or otherwise.)

The standard invoke wraps each object up as an any and stores it in a
vec, which is subsequently unwrapped.  This requires allocations on
the heap which must subsequently be garbage collected, as well as
wasting time in the wrapping and unwrapping.

"perform_call" keeps arguments in the form of a fevalue,
eliminating the need to do a heap allocation as was required for the
anys.  

In the interests of efficiency, other layers of abstraction have been
collapsed.  See "fast_invoke.cc" if you are really interested.

XXX This code assumes that garbage collection will not occur between
the time the invoked method returns and the results are sent to the
client.

 */
#include <stdio.h>
#include "runtime/obj.h"
#include "runtime/except.h"
#include "common/iter.h"
#include "common/array.h"
#include "runtime/value.h"
#include "types/type.h"
#include "types/vec_def.h"
#include "common/th_assert.h"
#include "types/string_class.h"

#define IS_BASIC_TYPE(t)      \
    (t==(type)Int || t==(type)Bool || t==(type)Char || t==(type)Real)

declareArray(array_of_feval, fevalue)

struct exceptional_return  {
    exception exc;
    fevalue *val;
};

extern exceptional_return last_invoke_exception;
// The last exceptional value returned by a method called via
// "fast_invoke".    




/*
   Invoke the function f (corresponding to the method "m") of type "t"
   on object "receiver", which must be an object of "t". The arguments
   "args" are passed to this method. They must also match the method
   specification. "m" must be a method such that
   "t.get_method(m.name())" returns "(m, t)".

*/
extern vec /* [type] */ get_exc_types(method m);
// Return what the method signals to
// pack exceptional results to the network, given the
// current value of "exc". If no such exception is
// signaled, return 0.


#define CAN_HANDLE_MORE_THAN_MAX_ARGS 0

inline
fevalue perform_call(obj receiver, ofunc f, fevalue* args, int num_args)
#define a(i) args[i].o
{
    
    // XXX This code assumes that obj is large enough to hold 
    // any result.XXX
    obj ret;
    switch(num_args) {
    case 0:
	fail("num_args = 0 in perform_call");
    case 1: ret = (obj) (*f)(receiver); break;
    case 2: ret = (obj) (*f)(receiver, a(0)); break;
    case 3: ret = (obj) (*f)(receiver, a(0), a(1)); break;
    case 4: ret = (obj) (*f)(receiver, a(0), a(1), a(2)); break;
    case 5: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3)); break;
    case 6: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4)); break;
    case 7: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5));
        break;
    case 8: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			     a(6)); break;
    case 9: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			     a(6), a(7)); break;
    case 10: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			     a(6), a(7), a(8)); break;
    case 11: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			     a(6), a(7), a(8), a(9)); break;
    case 12: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			      a(6), a(7), a(8), a(9), a(10)); break;
    case 13: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			      a(6), a(7), a(8), a(9), a(10), a(11)); break;
    case 14: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			      a(6), a(7), a(8), a(9), a(10), a(11), a(12)
			      ); break;
    case 15: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			      a(6), a(7), a(8), a(9), a(10), a(11), a(12),
			      a(13)); break;
    case 16: ret = (obj) (*f)(receiver, a(0), a(1), a(2), a(3), a(4), a(5),
			      a(6), a(7), a(8), a(9), a(10), a(11), a(12),
			      a(13), a(14)); break;
    default:
	th_assert(CAN_HANDLE_MORE_THAN_MAX_ARGS,
		  "Cannot handle more than MAX_ARGS arguments to invoke or iterate");
    }
    fevalue result;
    result.o = ret;
    return result;
#undef a
}


#endif /* _FAST_INVOKE_H */





