/*  Copyright 1995 Barbara Liskov */

#ifndef _FUTURE_H
#define _FUTURE_H

#include "common/intarray.h"
#include "common/iter.h"
#include "handle_def.h"
#include "types/any.h"
#include "runtime/value.h"
#include "runtime/obj.h"
#include "handle.h"

// Routines related to futures. See handle.h for an overview discussion of
// how futures work.

declareArray(FutureToAny, any)
declareArray(FutureToTag, char)

class future_table {
public:
  friend class FutureIter;

  future_table();
  // Initialize an empty table.

  void basic_to_future(type bt, fevalue v, future p);
  // Map basic value "v" of type "bt" onto future "p".

  handle_val future_to_any(handle h);

  void any_to_future(any a, future p);
  // Map "a" onto future "p".

  void get_future_handles(IntArray& futures, IntArray& handles);
  // requires: handles, futures have a size >= num_future_handles()+1
  // modifies: handles, futures
  // effects: Assigns new handles to futures in the the future table and
  //          puts the corresponding mapping in "handles"
  //          i.e. handles[i] is the handle/value corresponding to futures[i]

  inline void free_future(future p) {
      if (ftoa_tags[-p] != Emptyf) {
	      num_futures--;
      }
      ftoa_tags[-p] = Emptyf;
      ftoa_table[-p] = (any)0;
  }

  inline int num_future_handles() {
    return num_futures;
  }

 private:

  bool lookup(future p, char &t, any &a);

  bool store(future p, char t, any a);

  void free_all_futures();

  FutureToAny    ftoa_table;     // "ftoa_table[-h]" returns the value
                                 // associated with future "h".
  FutureToTag    ftoa_tags;      // "ftoa_tags[-h] returns a value
		                 // indicating the type of ftoa_table[-h]. 
  int num_futures;               // Number of actual futures in table.
};

#endif /* _FUTURE_H */
