// Copyright 1995 Barbara Liskov

// Generate the veneer include and stub files for a given type
#include "gen-C-veneer.h"
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>

static  void make_impl    (string filename, string contents);
static  void make_veneer_include (string filename, string contents);

void	gen_C_veneer_stub   (wr w, objtype t, method m, bool header_only);
void	gen_C_veneer_arg(wr w, formal f);

static void	C_veneer_typename(wr w, type t);
void	method_Cname  (wr w, objtype t, method m, bool meth);
void	put_type_code (wr w, type t);

bool is_parameterized(method m)
/* Return true if an argument or return value of "m" is parameterized */
{
  formal *args = UNPV(formal *, vec_items(m->arguments));;
  type *returns = UNPV(type *, vec_items(m->returns));;

  int i, 
    argc = vec_length(m->arguments),
    returnc = vec_length(m->returns);
  
  for (i=0; i<argc; i++)
    if (type_as_class(args[i]->t) == Param)
      return TRUE;

  for (i=0; i<returnc; i++)
    if (type_as_class(returns[i]) == Param)
      return TRUE;

  return FALSE;
}

void make_C_veneer_files(objtype t)
{
  string contents = gen_C_veneer_impl(t);
  string vname = string_concat(string_new("th_"), t->name);
  make_impl(string_concat(vname, string_new(".c")),
	    contents);

  contents = gen_C_veneer_header(t);
  make_veneer_include(string_concat(vname, string_new(".h")),
	       contents);

  FILE *typelist;
  if (typelist= fopen("th-typelist.h-th", "a")) {
      fprintf(typelist, "THOR_TYPE(th_%s);\n", string_charp(t->name));
      fclose(typelist);
  }
}

void gen_C_veneer_arg(wr w, formal f)
{
    // if (f->t == class_as_type(Null)) return;
    wr_putChars(w, ", ");
    C_veneer_typename(w, f->t);
    wr_putChar(w, ' ');
    wr_putString(w, f->name);
}

void gen_C_veneer_method_args(wr w, method m)
{
    int num_args = vec_length(m->arguments);
    formal *args = UNPV(formal *, vec_items(m->arguments));
    int i;
    for (i=0; i<num_args; i++) {
      gen_C_veneer_arg(w, args[i]);
    }
    if (vec_length(m->extra_args)) {
      wr_putChars(w, ", ...");
    }
    
    int num_rets = vec_length(m->returns);
    type *returns = UNPV(type *, vec_items(m->returns));

    if (num_rets > 1)
      for (i=0; i<num_rets; i++) {
	wr_putChars(w, ", ");
	C_veneer_typename(w, returns[i]);
	wr_putChars(w, " *res");
	wr_putChar(w, i+'1');
    }
}

void gen_C_veneer_args(wr w, method m, objtype t)
// Write out the C arguments to this method
{
/*
  if (t != class_as_objtype(Null)) {
*/
    C_veneer_typename(w, objtype_as_type(t));
    wr_putChars(w, " self");
/*
  } else {
    wr_putChars(w, "obj null_dummy");
  }
*/
  int num_rets = vec_length(m->returns);

  if (m->iter) 
    wr_putChars(w, ", struct closure");

  gen_C_veneer_method_args(w, m);
}

// Generate the C veneer stub for a method, or just the header if
// "header_only" is true.

void gen_C_veneer_stub(wr w, objtype t, method m, bool header_only)
{
  int num_rets = vec_length(m->returns);
  type ret;

  if (m->iter)			// iterators not supported 
    return;

// Output the function type
  switch (num_rets) {
  default:
    wr_putChars(w, "void ");
    break;
  case 1:
    ret = UNPV(type, vec_fetch(m->returns, 0));
    C_veneer_typename(w, ret);
    wr_putChar(w, ' ');
  }

// Output the function name and arguments
  method_Cname(w, t, m, FALSE);
  wr_putChar(w, '(');
  gen_C_veneer_args(w, m, t);
  wr_putChars(w, ")");

  if (header_only) {
    wr_putChars(w, ";\n");
    return;
  }

  wr_putChars(w, "\n{\n");

  if (num_rets==1) {
    wr_putChars(w, "   ");
    C_veneer_typename(w, ret);
    wr_putChars(w, " res;\n");
  }


// Output the invoke call
  wr_putChars(w, "   th_exc=invoke(self, \"");
  wr_putString(w, m->name);
  wr_putChars(w, "(");
    
  for (int len=vec_length(m->arguments), i=0; i < len ; i++) {
    formal f = UNPV(formal, vec_fetch(m->arguments, i));
    put_type_code(w, f->t);
    if (i<len-1) wr_putChars(w, ", ");
  }

  wr_putChars(w, ") -> (");
  for (len=vec_length(m->returns), i=0; i < len ; i++) {
    type ret = UNPV(type, vec_fetch(m->returns, i));
    put_type_code(w, ret);
    if (i<len-1) wr_putChars(w, ", ");
  }
  wr_putChars(w, ")\"");

  for (len=vec_length(m->arguments), i=0; i < len ; i++) {
    formal f = UNPV(formal, vec_fetch(m->arguments, i));
    wr_putChars(w, ", ");
    wr_putString(w, f->name);
  }

  for (i=0, len=vec_length(m->returns); i < len ; i++) {
    wr_putChars(w, ", &res");      
    if (len > 1) {
      char buf[8];
      sprintf(buf, "%d", i+1);
      wr_putChars(w, buf);
    }
  }

  wr_putChars(w, ");\n");
  if (vec_length(m->returns)==1)
    wr_putChars(w, "   return res;\n");
  wr_putChars(w, "}\n\n");
}

string gen_C_veneer_impl(objtype t)	
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "#include \"th_");
    wr_putString(w, t->name);
    wr_putChars(w, ".h-th\"\n\n");
    int num_methods = vec_length(t->methods_);
    method *m = UNPV(method *, vec_items(t->methods_));

    for (int i = 0; i < num_methods; i++) {
      if (is_parameterized(m[i])) {
	wr_putChars(w, "/*Parameterized methods currently not supported */\n");
	wr_putChars(w, "/* ");
	gen_C_veneer_stub(w, t, m[i], FALSE);
	wr_putChars(w, "  */\n");
      }
      else
	gen_C_veneer_stub(w, t, m[i], FALSE);
    }

    return textwr_toString(tw);
}

string gen_C_veneer_header(objtype t)	
{
  textwr tw = textwr_new();
  wr w = textwr_as_wr(tw);

  int num_methods = vec_length(t->methods_);
  method *m = UNPV(method *, vec_items(t->methods_));

  wr_putChars(w, "#include \"th-typelist.h\"\n");
  wr_putChars(w, "#include \"../th-veneer.h\"\n");

  for (int i = 0; i < num_methods; i++) {
    if (is_parameterized(m[i])) {
      wr_putChars(w, "/*Methods with parameterized types currently not supported */\n");
      wr_putChars(w, "/* ");
      gen_C_veneer_stub(w, t, m[i], TRUE);
      wr_putChars(w, "  */\n");
    }
      else gen_C_veneer_stub(w, t, m[i], TRUE);
    }

  return textwr_toString(tw);
}


      

void put_type_code(wr w, type t)
{
  if (t == (type)Int)
    wr_putChars(w, "%d");
  else if (t == (type)Char)
    wr_putChars(w, "%c");
  else if (t == (type)Bool)      
    wr_putChars(w, "%b");
  else if (t == (type)Real)      
    wr_putChars(w, "%f");
  else if (t == (type)Null)      
    wr_putChars(w, "%d");
  else
    wr_putChars(w, "%h");
}


static void C_veneer_typename(wr w, type t)
{
/*
  if (t == (type)Null)
    wr_putChars(w, "void");
  else {
*/
      char *param_pos;
      char *typename = type_name(t)->chars;

      if (t!=(type)Int && t!=(type)Bool && t!=(type)Char && t!=(type)Real
		&& t!=(type)Null)
	  wr_putChars(w, "th_");

// hack to handle vec[any] and other parameterized types
      param_pos = strchr(typename, '[');
      if (!param_pos)
	  wr_putChars(w, typename);
      else {
	  char *c = typename;
	  while (c < param_pos) 
	      wr_putChar(w, *c++);
      }
/*
  }
*/
}



static void make_impl(string filename, string contents)
{
  char const *fn = string_charp(filename);

  FILE *f = fopen(string_charp(filename), "w");
  fputs(string_charp(contents), f);
  fclose(f);
}

static void make_veneer_include(string filename, string contents)
{
    char const *fn = string_charp(filename);
    string filename2 = string_concat(filename, string_new("-th"));

    FILE *f = fopen(string_charp(filename2), "w");
    string ifdef_name;
    {
      textwr tw = textwr_new();
	wr w = textwr_as_wr(tw);
	char const *end = fn + strlen(fn) - 1;
	while (end > fn && *end != '/') end--;
	wr_putChar(w, '_');
	while (*end) {
	    if (*end != '.')
	      wr_putChar(w, toupper(*end));
	    else
	      wr_putChar(w, '_');
	    end++;
	}
	ifdef_name = textwr_toString(tw);
    }
    fprintf(f, "#ifndef %s\n#define %s\n\n",
	    string_charp(ifdef_name),
	    string_charp(ifdef_name));
    fputs(string_charp(contents), f);
    fprintf(f, "\n#endif /* %s */\n", string_charp(ifdef_name));
    fclose(f);
}
