// Copyright 1995 Barbara Liskov

#include "gen-include.h"
#include "runtime/surr.h"

#include "types/type_meth.h"
#include "types/string_class.h"
#include "types/textwr.h"
#include "types/vec.h"
#include "types/vec_class.h"
#include "types/class.h"
#include "types/pclass.h"
#include "types/class_class.h"

#include "common/openhashset.h"

#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>

/* 
   These routines are largely naive about adding includes for
   types used in method signatures...
*/

/* Definitions for getting the correct include files. */

#define string_compare(x, y) (!strcmp(x, y))

declareOpenHashSet(TypeNmSet, const char *, hash_string, string_compare)
implementOpenHashSet(TypeNmSet, const char *, hash_string, string_compare)

void method_Cname(wr w, objtype t, method m, bool meth);
void gen_meth_inc_inc(wr w, objtype objt, objtype st);

static void structName(wr w, objtype t)
{
    wr_putChars(w, "struct ");
    wr_putString(w, t->name);
    wr_putChars(w, "_s ");
}

static void dvName(wr w, objtype t)
{
    wr_putChars(w, "struct ");
    wr_putString(w, t->name);
    wr_putChars(w, "dv_s ");
}

void make_include(string filename, string contents)
{
    char const *fn = string_charp(filename);
    string filename2 = string_concat(filename, string_new("-th"));
    if (0 == access(string_charp(filename2), F_OK)) {
	string bakfile = string_concat(filename2, string_new("~"));
	if (0>rename(string_charp(filename2),
		     string_charp(bakfile))) {
	    perror(string_charp(filename2));

	};
    }
    FILE *f = fopen(string_charp(filename2), "w");
    string ifdef_name;
    {
	textwr tw = textwr_new();
	wr w = textwr_as_wr(tw);
	char const *end = fn + strlen(fn) - 1;
	while (end > fn && *end != '/') end--;
	wr_putChar(w, '_');
	while (*end) {
	    if (*end != '.')
	      wr_putChar(w, toupper(*end));
	    else
	      wr_putChar(w, '_');
	    end++;
	}
	ifdef_name = textwr_toString(tw);
    }
    fprintf(f, "#ifndef %s\n#define %s\n\n",
	    string_charp(ifdef_name),
	    string_charp(ifdef_name));
    fputs(string_charp(contents), f);
    fprintf(f, "\n#endif /* %s */\n", string_charp(ifdef_name));
    fclose(f);
}

void make_rtn_includes(method m)
{
   string contents = gen_rtn_spec_inc(m);
   make_include(string_concat(m->name, string_new(".h")),
		contents);
}


/* Definitions for getting the correct include files. */void make_includes(objtype t)
{
    string contents = gen_def_inc(t);
    make_include(string_concat(t->name, string_new("_def.h")),
		 contents);
    contents = gen_spec_inc(t);
    make_include(string_concat(t->name, string_new(".h")),
		 contents);
    contents = gen_meth_inc(t);
    make_include(string_concat(t->name, string_new("_meth.h")),
		 contents);

    class_ c = objtype_as_class(t);
    if (exc) {
	exc = EXC_NONE;
	return;
    }
    contents = gen_class_inc(c);
    make_include(string_concat(t->name, string_new("_class.h")),
		 contents);
}

string gen_def_inc(objtype t)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "typedef ");
    structName(w, t);
    wr_putChar(w, '*');
    wr_putString(w, t->name);
    wr_putChars(w, "_C;\n");
    wr_putChars(w, "typedef ");
    dvName(w, t);
    wr_putChars(w, "**");
    wr_putString(w, t->name);
    wr_putChars(w, ";\n");
    return textwr_toString(tw);
}

void type_Cname(wr w, type t)
{
    if (t == (type)Null)
	wr_putChars(w, "null");
    else if (t == (type)Real)
	wr_putChars(w, "real");
    else if (t == (type)Type)
	wr_putChars(w, "type");
    else if (t == (type)Class)
	wr_putChars(w, "class_");
    else wr_putString(w, type_name(t));
}

void type_Cname_short(wr w, type t)
{
    if (t == (type)Null)
	wr_putChars(w, "null");
    else if (type_kind(t) == PARAM_KIND)
	wr_putChars(w, "pval");
    else if (t == (type)Real)
	wr_putChars(w, "real");
    else if (t == (type)Type)
	wr_putChars(w, "type");
    else if (t == (type)Class)
	wr_putChars(w, "class_");
    else {
	    string cname = type_name(t);
	    const char *cnm = string_charp(cname);
	    char *cptr = index(cnm, '[');
	    if (cptr) cname = string_newn(cnm, cptr-cnm);
	    wr_putString(w, cname);
	 }
}

void method_Cname(wr w, objtype t, method m, bool meth)
{
    int l = string_length(m->name);
    bool ends_bang = string_fetch(m->name, l - 1) == '!';

    if (!meth && t) {
	wr_putString(w, t->name);
	wr_putChar(w, '_');
    }
    if (ends_bang) {
	wr_putChars(w, "change_");
	l--;
    }
    int i;
    for (i=0; i<l; i++) {
	char c = string_fetch(m->name, i);
	wr_putChar(w, c);
    }
}

void gen_spec_arg(wr w, formal f)
{
//    if (f->t == class_as_type(Null)) return;
    wr_putChars(w, ", ");
    type_Cname_short(w, f->t);
    wr_putChar(w, ' ');
    wr_putString(w, f->name);
}

void gen_spec_method_args(wr w, method m)
{
    int num_args = vec_length(m->arguments);
    formal *args = (formal *)vec_items(m->arguments);
    int i;
    for (i=0; i<num_args; i++) {
	gen_spec_arg(w, args[i]);
    }
    if (vec_length(m->extra_args)) {
	wr_putChars(w, ", ...");
    }
}

void gen_spec_C_args(wr w, method m, objtype t)
/* Write out the C arguments to this method. */
{
    // if (m->parameterized) {
    // 	wr_putChars(w, "void *pblock, ");
    // }
    if (t != (objtype)0) {
	type_Cname_short(w, objtype_as_type(t));
	wr_putChars(w, " self");
    } else {
	wr_putChars(w, "obj null_dummy");
    }
    int num_rets = vec_length(m->returns);
    if (num_rets > 1) {
	wr_putChars(w, ", fevalue *__retvals");
    }
    if (m->iter) {
	wr_putChars(w, ", struct closure");
    }
    gen_spec_method_args(w, m);
}

void gen_spec_method(wr w, method m, objtype t, bool meth)
{
    if (!meth) wr_putChars(w, "extern ");
    else wr_putChars(w, "  ");
    int num_rets = vec_length(m->returns);
    switch (num_rets) {
      default:
	wr_putChars(w, "void ");
	break;
      case 1:
	objtype t = UNPV(objtype, vec_fetch(m->returns, 0));
	type_Cname_short(w, objtype_as_type(t));
	wr_putChar(w, ' ');
    }
    if (meth) wr_putChars(w, "(*");
    method_Cname(w, t, m, meth);
    if (meth) wr_putChars(w, ")");
    wr_putChar(w, '(');
    gen_spec_C_args(w, m, t);
    wr_putChars(w, ");\n");
    if (!meth) {
	wr_putChars(w, "/*\n");
	wr_putString(w, m->spec);
	wr_putChars(w, "\n*/\n");
    }
}

void gen_spec_method_(wr w, method m, objtype t, bool meth)
{
    if (!meth) wr_putChars(w, "extern ");
    else wr_putChars(w, "  ");
    int num_rets = vec_length(m->returns);
    switch (num_rets) {
      default:
	wr_putChars(w, "void ");
	break;
      case 1:
	objtype t = UNPV(objtype, vec_fetch(m->returns, 0));
	type_Cname_short(w, objtype_as_type(t));
	wr_putChar(w, ' ');
    }
    if (meth) wr_putChars(w, "(*");
    method_Cname(w, t, m, meth);
    wr_putChars(w, "_");
    if (meth) wr_putChars(w, ")");
    wr_putChar(w, '(');
    gen_spec_C_args(w, m, t);
    wr_putChars(w, ");\n");
    if (!meth) {
	wr_putChars(w, "/*\n");
	wr_putString(w, m->spec);
	wr_putChars(w, "\n*/\n");
    }
}

string gen_spec_inc(objtype t)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "#include \"");
    wr_putString(w, t->name);
    wr_putChars(w, "_def.h\"\n\n");
    // The following is a hack and should be replaced by
    // 	includes for all types used in signatures...
    int nst = vec_length(t->supertypes_);
    objtype st;
    if (nst) st = UNPV(objtype, vec_fetch(t->supertypes_, 0));
    else st = 0;
    if (st && st != Any) {
      wr_putChars(w, "#include \"");
      wr_putString(w, st->name);
      wr_putChars(w, "_meth.h\"\n");
      wr_putChars(w, "#include \"");
      wr_putString(w, st->name);
      wr_putChars(w, ".h\"\n");
    }
    gen_meth_inc_inc(w, t, st);
    wr_putChars(w, "extern ");
    exc = EXC_NONE;
    class_ c = objtype_as_class(t);
    if (exc) wr_putChars(w, "type ");
    else wr_putChars(w, "class_ ");
    exc = EXC_NONE;
    wr_putString(w, t->name);
    wr_putChars(w, "V;\n");
    int num_methods = vec_length(t->methods_);
    method *m = (method *)vec_items(t->methods_);
    wr_putChars(w, "#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
    wr_putChars(w, "/*\n");
    wr_putString(w, t->overview);
    wr_putChars(w, "\n*/\n");
    int i;
    for (i = 0; i < num_methods; i++) {
	gen_spec_method(w, m[i], t, FALSE);
    }
    wr_putChars(w, "\nextern void init");
    wr_putString(w, t->name);
    wr_putChars(w, "();\n");
    wr_putChars(w, "\n#ifdef __cplusplus\n}\n#endif\n");
    return textwr_toString(tw);
}

void gen_meth_inc_inc(wr w, objtype objt, objtype st)
{
    TypeNmSet types_used;
    int i, j, k;

    int num_methods = vec_length(objt->methods_);
    method *mp = (method *)vec_items(objt->methods_);
    for (i = 0; i < num_methods; i++) {
      method m = mp[i];
      if (vec_length(m->arguments)) {
	for (j = 0; j < vec_length(m->arguments); j++) {
		formal f = UNPV(formal, vec_fetch(m->arguments, j));
		objtype ot = type_as_objtype(f->t);
		if (ot == objt || ot == st) continue;
	        types_used.insert(string_charp(typeExtNm2SimpleNm(
			type_name(f->t))));
		}
	}
      if (vec_length(m->returns)) {
	for (j = 0; j < vec_length(m->returns); j++) {
		type t = UNPV(type, vec_fetch(m->returns, j));
		objtype ot = type_as_objtype(t);
		if (ot == objt || ot == st) continue;
	        types_used.insert(string_charp(typeExtNm2SimpleNm(
			type_name(t))));
		}
	}
      if (vec_length(m->signals)) {
	for (j = 0; j < vec_length(m->signals); j++) {
		signal_ s = UNPV(signal_, vec_fetch(m->signals, j));
		if (vec_length(s->returns)) {
			for (k = 0; k < vec_length(s->returns); k++) {
				type t = UNPV(type, vec_fetch(s->returns, k));
				objtype ot = type_as_objtype(t);
				if (ot == objt || ot == st) continue;
	        		types_used.insert(string_charp(
					typeExtNm2SimpleNm( type_name(t))));
				}
			}
		}
	}
    }
    for (TypeNmSet::Elements each(&types_used); each.ok(); each.next()) {
	const char *included_tnm = each.get();
	wr_putChars(w, "#include \"");
	wr_putChars(w, included_tnm);
	wr_putChars(w, ".h\"\n");
	}
}

string gen_meth_inc(objtype t)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    int nst = vec_length(t->supertypes_);
    objtype st;
    if (nst) st = UNPV(objtype, vec_fetch(t->supertypes_, 0));
    else st = 0;
    /*
       Note that as currently defined, the methods of "t" are
       congruent with the methods of its first direct supertype.
    */
    if (st && st != Any) {
      wr_putChars(w, "#include \"");
      wr_putString(w, st->name);
      wr_putChars(w, "_meth.h\"\n");
    }
    wr_putChars(w, "#include \"");
    wr_putString(w, t->name);
    wr_putChars(w, ".h\"\n");
    gen_meth_inc_inc(w, t, st);
    wr_putChars(w, "#include \"runtime/obj_class.h\"\n\n");
    wr_putChars(w, "struct ");
    wr_putString(w, t->name);
    wr_putChars(w, "dv_s {\n");
    wr_putChars(w, "  struct ");
    if (st && st != Any) {
      wr_putString(w, st->name);
    }
    wr_putChars(w, "dv_s super;\n");
    int num_methods = vec_length(t->methods_);
    method *m = (method *)vec_items(t->methods_);
    int i;
    for (i = 0; i < num_methods; i++) {
      gen_spec_method(w, m[i], t, TRUE);
    }
    wr_putChars(w, "};\n");
    return textwr_toString(tw);
}

string gen_class_inc(class_ c)
{
    FIX(c, class_);
    textwr tw = textwr_new();
    objtype t = class_as_objtype(c);
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "#include \"");
    wr_putString(w, t->name);
    wr_putChars(w, "_meth.h\"\n");
    class_ sc = class_superclass(c);
    if (exc) {
	sc = 0;
	exc = EXC_NONE;
    } else {
	FIX(sc, class_);
    }
    if (sc) {
      wr_putChars(w, "#include \"");
      wr_putString(w, sc->hdr.inh.name);
      wr_putChars(w, "_class.h\"\n\n");
    }

    if (!c->special) {
	formal *fields = (formal *)vec_items(c->fields);
	int l = vec_length(c->fields);
	int i;
	TypeNmSet types_used;
	for (i = 0; i < l; i++) {
	    formal f = fields[i];
	    types_used.insert(string_charp(typeExtNm2SimpleNm(type_name(f->t))));
	}
        for (TypeNmSet::Elements each(&types_used); each.ok(); each.next()) {
            const char *included_tnm = each.get();
            wr_putChars(w, "#include \"");
	    wr_putChars(w, included_tnm);
            wr_putChars(w, ".h\"\n");
        }
    }

    structName(w, t);
    wr_putChars(w, "{\n");

    wr_putChars(w, "  union {\n");

    if (sc) {
	wr_putChars(w, "    ");
	structName(w, class_as_objtype(sc));
	wr_putChars(w, " inh;\n");
    } else {
	wr_putChars(w, "    struct core_s inh;\n");
    }
    wr_putChars(w, "    struct ");
    wr_putString(w, t->name);
    wr_putChars(w, "dv_s *methods;\n");
    wr_putChars(w, "  } hdr;\n");
    if (c->special) {
	wr_putString(w, c->specialText);
    } else {
	int l = vec_length(c->fields);
	int i;
	int skip;
	if (sc) {
	    skip = vec_length(sc->fields);
	} else {
	    skip = 0;
	}
	formal *fields = (formal *)vec_items(c->fields);
	for (i = skip; i < l; i++) {
	    formal f = fields[i];
	    wr_putChars(w, "  ");
	    type_Cname_short(w, f->t);
	    wr_putChar(w, ' ');
	    wr_putString(w, f->name);
	    wr_putChars(w, ";\n");
	}
    }
    wr_putChars(w, "};\n\n");

/*
    wr_putChars(w, "typedef struct ");
    wr_putString(w, t->name);
    wr_putChars(w, "_s *");
    wr_putString(w, t->name);
    wr_putChars(w, ";\n");
*/

    wr_putChars(w, "extern struct ");
    wr_putString(w, t->name);
    wr_putChars(w, "dv_s ");
    wr_putString(w, t->name);
    wr_putChars(w, "_methods;\n\n");

    int num_methods = vec_length(t->methods_);
    method *m = (method *)vec_items(t->methods_);
    int i;
    for (i = 0; i < num_methods; i++) {
        gen_spec_method_(w, m[i], t, FALSE);
	}

    return textwr_toString(tw);
}

string gen_rtn_spec_inc(method m)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
    gen_spec_method(w, m, 0, FALSE);
    wr_putChars(w, "extern ");
    wr_putChars(w, "class_ ");
    wr_putString(w, m->name);      // possibly should be methodCname...
    wr_putChars(w, "_rtn_classV;\n");
    wr_putChars(w, "extern void init");
    wr_putString(w, m->name);      // possibly should be methodCname...
    wr_putChars(w, "_rtn_class();\n");
/*
    wr_putChars(w, "\nextern void init");
    wr_putString(w, t->name);
    wr_putChars(w, "();\n");
*/
    wr_putChars(w, "\n#ifdef __cplusplus\n}\n#endif\n");
    return textwr_toString(tw);
}
