/*  Copyright 1995 Barbara Liskov */

#ifndef _HANDLE_GC_H
#define _HANDLE_GC_H

#include "handle.h"

class HandleIter {
  //  Once created, an iterator must be used and destroyed before any 
  //  handles are created (e.g. by handle_atoh) or destroyed (e.g. by
  //  free_handle).  The effect is undefined if an iterator method 
  //  is called after such a change.
 public: 
  HandleIter();
  bool ok();           // is get() legal?
  handle get_handle(); // get current handle
  obj get_obj();       // get corresponding object
  void next();         // advance iterator
  void replace(handle, obj); // replace the current handle->obj mapping
                             // (checked runtime error to supply wrong handle)
 private:
  int index;
};


// Similar to the one above. We could try and merge these
class FutureIter {
  //  Once created, an iterator must be used and destroyed before any 
  //  handles are created (e.g. by future_atoh) or destroyed (e.g. by
  //  free_future).  The effect is undefined if an iterator method 
  //  is called after such a change.
 public: 
    FutureIter();
    bool ok();           // is get() legal?
    future get_future(); // get current handle
    obj get_obj();       // get corresponding object
    void next();         // advance iterator
    void replace(future, obj); // replace the current handle->obj mapping
    // (checked runtime error to supply wrong future)
 private:
  int index;
};


// Private operations used only by gc

extern void handle_gc_moved_object(handle h, obj new_);
  // effects - update handle table so that handle h now points to new_.

#endif /* _HANDLE_GC_H */
