/*  Copyright 1995 Barbara Liskov */

#ifndef _INVOKE_H
#define _INVOKE_H

#include "runtime/value.h"
#include "runtime/obj.h"
#include "runtime/except.h"
#include "types/type.h"
#include "types/vec_def.h"
#include "common/iter.h"

#ifdef __cplusplus
extern "C" {
#endif
    
typedef enum { rt_normal, rt_exceptional } result_type;

typedef struct {
    result_type tag;
    union {
	vec normal; /* vec[any] */
	struct {
	    exception exc;
	    vec val; /* vec[any] */
	} exceptional;
    } u;
} rt_result;
/*
    An "rt_result" is the type used to describe the return result of
    a Theta procedure. Such a procedure returns either normally or
    exceptionally, corresponding to the two arms of the union "u".
*/
	
typedef struct rt_iter_s *rt_iter;
    
void init_invocations();
/*
   Initialize state associated with invocation mechanism.  This must
   be called before the first time that "invoke" is called.
*/

extern rt_result invoke(fevalue self, objtype t, method m, vec args);
/*
   Invoke the method "m" of type "t" on object "self", which must be an
   object of "t". The arguments "args" are passed to this method. They
   must also match the method specification. "m" must be a method such
   that "t.get_method(m.name())" returns "(m, t)".

   The method may generate a "failure" exception. If so, this procedure
   will catch the failure and place the appropriate result in the return
   value.
*/

extern rt_result iterate(fevalue self, objtype t, method m, vec args,
			 struct closure cl);
/* 
   Invoke the iterator "m" of type "t" on object "self", which must be
   an object of "t". The arguments "args" are passed to this method.
   They must also match the method specification. "m" must be an iterator
   method. The values yielded by the iterator will be passed to the
   closure "cl".

   The result returned by "iterate" has tag "rt_normal" and zero results
   if the iterator terminated normally. If the iterator or the 
   closure "cl" raises an exception, the result will have tag
   "rt_exception", and the exception will be reported in the result,
   as normal.
*/

vec unpack_results(fevalue *rets, vec retTypes);
/*
    Return a "vec[any]" that contains the values in "rets", as
    described by the type vector "retTypes".
*/
    
#ifdef __cplusplus
}
#endif

#endif /* _INVOKE_H */
