// Copyright 1995 Barbara Liskov

#include <stdio.h>
#include "types/method.h"
#include "runtime/value.h"
#include "runtime/discover_fix.h"
#include "parse_tree.h"
#include "handle.h"
#include "fast_invoke.h"
#include "binary_interface.h"
#include "controls.h"
#include "types/cell.h"

// VarNode implementations.

any FutureOffsetNode::get_val() {
  any res =  (any)((DV)(*r)+hdroff);   //XXX This is totally wrong!!!

  return res;
}

ofunc FutureOffsetNode::compute_func(method m) {
  any r = get_val();              // Does the offset.
  return compute_any_func((obj)r, m);
}

// MethodNode implementations.

inline obj call_ofunc_0argument(obj receiver, ofunc f) {
  return ((obj) (*f)(receiver));
}

inline obj call_ofunc_1argument(obj receiver, ofunc f, obj arg) {
  return ((obj) (*f)(receiver, arg));
}

// Exceptions need only be checked after the actual function call.

inline void handle_method_exception(MethodNode *n) {
  // Handle an exception that occurs when a method function is called.

#if DEBUG_CONTROLS
  fprintf(stderr, "Exception occurred in method evalutation:");
  fprintf(stderr, " %s\n", string_charp(exc->name));
  n->print_node();
#endif

  // XXX Set all result futures to exception!!!

  exc = EXC_NONE;
}

inline void check_method_exception() {
  // If an exception occurred during a method call, save it and signal
  // failure.  The failure will get caught in control.cc, function
  // "end_control"
  if (exc) {
    control_exc = exc;
    control_exc_value = exc_value;
    signal_failure(0);
  }
}

inline void check_method_exception_result(MethodNode *n, bool not_basic,
					  fevalue res, obj_ref r) {
  // Check whether an exception occurred during a method call.  If
  // not, put the result of the call in r.

  check_method_exception();

  if (not_basic) {
    FIX(res.o, obj);
  }
  *r = res.o;
}

virtual void Method_cell_getNode::eval_node() {
  fevalue res;

  res.o = (obj)cell_get((cell)(receiver->get_val()));

  check_method_exception_result(this, not_basic_result, res, result);
}

virtual void Method_cell_putNode::eval_node() {
  cell_put((cell)(receiver->get_val()), arg->get_val());

  check_method_exception();
}

void Method0_0_ConstantNode::eval_node() {
  call_ofunc_0argument(any_as_obj(receiver), f);

  check_method_exception();
}

void Method1_0_ConstantNode::eval_node() {
  fevalue res;

  res.o = call_ofunc_0argument(any_as_obj(receiver), f);

  check_method_exception_result(this, not_basic_result, res, result);
}

void Method0_1C_ConstantNode::eval_node() {
  call_ofunc_1argument(any_as_obj(receiver), f, any_as_obj(arg));

  check_method_exception();
}

void Method0_1F_ConstantNode::eval_node() {
  obj real_arg = any_as_obj(arg->get_val());

  call_ofunc_1argument(any_as_obj(receiver), f, real_arg);

  check_method_exception();
}

void Method1_1C_ConstantNode::eval_node() {
  fevalue res;

  res.o = call_ofunc_1argument(any_as_obj(receiver), f, any_as_obj(arg));

  check_method_exception_result(this, not_basic_result, res, result);
}

void Method1_1F_ConstantNode::eval_node() {
  fevalue res;

  obj real_arg = any_as_obj(arg->get_val());
  
  res.o = call_ofunc_1argument(any_as_obj(receiver), f, real_arg);

  check_method_exception_result(this, not_basic_result, res, result);
}

void Method1_n_ConstantNode::eval_node() {
  fevalue real_args[MAX_ARGS];
 
  for (int i = 0; i < num_args; i++)
    real_args[i].o = any_as_obj(args[i]->get_val());

  fevalue res = perform_call(any_as_obj(receiver), f, real_args, num_args+1);

  check_method_exception_result(this, not_basic_result, res, result);
}

void Methodk_n_ConstantNode::eval_node() {
  fevalue real_args[MAX_ARGS];
 
// Put return_buff, etc.

  for (int i = 0; i < num_args; i++)
    real_args[i].o = any_as_obj(args[i]->get_val());

  fevalue res = perform_call(any_as_obj(receiver), f, real_args, num_args+1);

  check_method_exception();

  //XXX results???!!!
}

void Method0_0_FutureNode::eval_node() {
  any rec = receiver->get_val();

  f = receiver->compute_func(m);

  call_ofunc_0argument(any_as_obj(rec), f);
  check_method_exception();
}

void Method1_0_FutureNode::eval_node() {
  any rec = receiver->get_val();

  f = receiver->compute_func(m);

  fevalue res;

  res.o = call_ofunc_0argument(any_as_obj(rec), f);

  check_method_exception_result(this, not_basic_result, res, result);
}

void Method0_1C_FutureNode::eval_node() {
  any rec = receiver->get_val();

  f = receiver->compute_func(m);

  call_ofunc_1argument(any_as_obj(rec), f, any_as_obj(arg));
  check_method_exception();
}

void Method0_1F_FutureNode::eval_node() {
  any rec = receiver->get_val();

  f = receiver->compute_func(m);

  call_ofunc_1argument(any_as_obj(rec), f, any_as_obj(arg->get_val()));

  check_method_exception();
}

void Method1_1C_FutureNode::eval_node() {
  any rec = receiver->get_val();

  f = receiver->compute_func(m);

  fevalue res;

  res.o = call_ofunc_1argument(any_as_obj(rec), f, any_as_obj(arg));

  check_method_exception_result(this, not_basic_result, res, result);
}

void Method1_1F_FutureNode::eval_node() {
  any rec = receiver->get_val();

  f = receiver->compute_func(m);

  fevalue res;

  res.o = call_ofunc_1argument(any_as_obj(rec), f,
				       any_as_obj(arg->get_val())); 
  check_method_exception_result(this, not_basic_result, res, result);
}

void Method1_n_FutureNode::eval_node() {
  any rec = receiver->get_val();

  f = receiver->compute_func(m);

  fevalue real_args[MAX_ARGS];
 
  for (int i = 0; i < num_args; i++)
    real_args[i].o = any_as_obj(args[i]->get_val());

  fevalue res = perform_call(any_as_obj(rec), f, real_args, num_args+1);

  check_method_exception_result(this, not_basic_result, res, result);
}

void Methodk_n_FutureNode::eval_node() {
  any rec = receiver->get_val();

  f = receiver->compute_func(m);

  fevalue real_args[MAX_ARGS];
 
// Put return_buff, etc.

  for (int i = 0; i < num_args; i++)
    real_args[i].o = any_as_obj(args[i]->get_val());

  fevalue res = perform_call(any_as_obj(rec), f, real_args, num_args+1);

  if (!exc) {
//    future_btof(result_type, res, result);
    return;
  }
  handle_method_exception(this);
}

void MethodXNode::eval_node() {
  f = self->compute_func(m);

  // fprintf(stderr, "Function computed!\n");

  fevalue real_args[MAX_ARGS];

  //XXX Make sure num_args <= MAX_ARGS
  //XXX Will deal with multiple return later
  for (int i = 0; i < num_args; i++)
    real_args[i].o = any_as_obj(args[i]->get_val());

  obj receiver = any_as_obj(self->get_val());

#if DEBUG_CONTROLS
  fprintf(stderr, "Calling method %s with rec = %d, arg = %d\n",
	  string_charp(m->name), (long)receiver, real_args[0].i);
#endif

  fevalue result = perform_call(receiver, f, real_args, num_args+1);

  //XXX Deal with multiple results later!

  if (num_rets == 0)
    check_method_exception();
  else
    if (num_rets == 1) {
      //XXX This isn\'t right!
      obj_ref r;
      find_type(results[0], r);
      check_method_exception_result(this, !is_basic_type(result_types[0]), result, r);
    }
    else {
      //XXX Need to finish this.
      fprintf(stderr, "XXX Multiple results not implemented!!!!!!\n");
    }

  //fprintf(stderr, "Evaluation succesful\n");
  return;
}

// IfNode implementations.

void IfNode::eval_node() {
  eval_tree(expr);

  if (condition->get_val())
    eval_tree(then_branch);
  else
    eval_tree(else_branch);
}

bool IfNode::begin_then(VarNode *c) { 
  condition = c;
  if (state != Expression) {
#if DEBUG_CONTROLS
    fprintf(stderr, "IfNode::begin_then: State must be expression!\n");
#endif
    return FALSE;
  }
  if ((condition->tag == Val_Node) && expr) {
#if DEBUG_CONTROLS
    fprintf(stderr, "IfNode::begin_then: Cannot have constant condition if there is an expression\n");
    // XXX else contition->handle must== tail->result_handle!?
#endif
    return FALSE;
  }
  state = ThenBody;
}

bool IfNode::begin_else() { 
  if (state != ThenBody) {
#if DEBUG_CONTROLS
    fprintf(stderr, "IfNode::begin_else: State must be ThenBody!\n");
#endif
    return FALSE;
  }
  state = ElseBody;
}

Node *IfNode::optimize() {
  if (condition->tag == Val_Node) { // Constant value!  Can optimize.
//    fprintf(stderr, "Optimizing IfNode!");
    if (condition->get_val())
      return then_branch;
    else
      return else_branch;
  }
  return this;
}

bool IfNode::add_node(Node *n) {
  // fprintf(stderr, "Adding node to if node\n");
  // n->print_node();

  switch(state) {
    case Expression: {
      MethodNode *e;

      if (n->tag == Method_Node)
	e = (MethodNode*)n;
      else {
#if DEBUG_CONTROLS
	fprintf(stderr, "IfNode::add_node: Illegal node being added to expression!\n");
	n->print_node();
#endif
	return FALSE;
      }
      
      if (!expr) {
	tail = expr = e;
      }
      else
	tail = tail->next = e;
      break;
    }  
    case ThenBody: {
      if (!then_branch)
	then_branch = tail = n;
      else
	tail = tail->next = n;
      break;
    } 
    case ElseBody: {
      if (!else_branch)
	else_branch = tail = n;
      else
	tail = tail->next = n;
      break;
    } 
    default:
      fprintf(stderr,"IfNode::add: Unknown state?!\n");
      return FALSE;
  }
}

// LoopNode implementations

bool LoopNode::begin_body(VarNode *c) { 
  condition = c;
  if (state != Expression) {
#if DEBUG_CONTROLS
    fprintf(stderr, "LoopNode::begin_then: State must be expression!\n");
#endif
    return FALSE;
  }
  if ((condition->tag == Val_Node) && expr) {
#if DEBUG_CONTROLS
    fprintf(stderr, "IfNode::begin_then: Cannot have constant condition if there is an expression\n");
    // XXX else contition->handle must== tail->result_handle!?
#endif
    return FALSE;
  }
  state = Body;
}

bool LoopNode::add_node(Node *n) {
  // fprintf(stderr, "Adding node to loop node\n");
  // n->print_node();

  switch(state) {
    case Expression: {
      MethodNode *e;

      if (n->tag == Method_Node)
	e = (MethodNode*)n;
      else {
#if DEBUG_CONTROLS
	fprintf(stderr, "LoopNode::add_node: Illegal node being added to expression!\n");
	n->print_node();
#endif
	return FALSE;
      }
      
      if (!expr) {
	tail = expr = e;
      }
      else
	tail = tail->next = e;
      break;
    }  
    case Body: {
      if (!body)
	body = tail = n;
      else
	tail = tail->next = n;
      break;
    } 
    default:
      fprintf(stderr,"LoopNode::add: Unknown state?!\n");
      return FALSE;
  }
}

void LoopNode::eval_node() {
  while (TRUE) {
    eval_tree(expr);

    if (condition->get_val())
      eval_tree(body);
    else
      break;
  }
}

// IterNode implementations.


struct Iter1_env {
  Node *body;                       // Body of FOR statement.
  obj_ref r;                        // Future for result of iterator.
  type t;                           // Type yielded by iterator.
};

void eval_iter1(void *env, obj res) {
  obj_ref r = ((Iter1_env*)env)->r;            // Unecessary
  type t = ((Iter1_env*)env)->t;

  *r = res;

  eval_tree(((Iter1_env*)env)->body);       // Evaluate the body of the loop.
}

bool IterNode::add_node(Node *n) {
  switch(state) {
    case Expression: {
      MethodNode *e;

      if (n->tag == Method_Node) {
	iterator = (MethodIterNode*)n;
	state = Body;
      }
      else {
#if DEBUG_CONTROLS
	fprintf(stderr, "IterNode::add_node: Illegal node being added to expression!\n");
	n->print_node();
#endif
	return FALSE;
      }
      break;
    }  
    case Body: {
      if (!body)
	body = tail = n;
      else
	tail = tail->next = n;
      break;
    } 
    default:
      fprintf(stderr,"IterNode::add: Unknown state?!\n");
      return FALSE;
  }
}

void IterNode::end_body() {
  // Create the actual call to the iterator, which will include the
  // body of the FOREACH as part of the closure.
  iterator = ((MethodIterNode*)iterator)->specialize(body);
}

void IterNode::eval_node() {
  iterator->eval_node();    // Unnecessary level of indirection!!!
}

MethodNode*
MethodIterNode::specialize(Node *body) {
  if (num_rets > 1) {
    fprintf(stderr, "Multiple yields unsupported!!\n"); //XXXXXXX
    return 0;
  }

  num_args = num_args+2; //XXX 2 more for the closure.

  Iter1_env *env = new Iter1_env();

  env->body = body;
  env->t = result_types[0];
  find_type(results[0], env->r);

  //XXX This represents a struct closure, where c.f = eval_iter1, and
  //c.env = env.  The struct is passed as two seperate arguments each
  //containing one of the two fields.

  args[0] = new ValNode((any)eval_iter1);
  args[1] = new ValNode((any)env);

  num_rets = 0;          //XXX iterator doesn\'t really return.

  cell_method cm = NONE;

  return create_specialized_method_node(self, m, num_args, args,
					num_rets, results,
					result_types, cm);
}

// Misc.

MethodNode* create_specialized_method_node(
	VarNode* self, method m, int num_args, VarNode** args, int
	num_rets, int *results, type* ret_types, cell_method cm)
{
  // Specialize the MethodNode for better performance.
  obj_ref r;

  // Special case for cell methods.
  if (cm == PUT) {
    return new Method_cell_putNode(self, args[0]);
  }
  if (cm == GET) {
    find_type(results[0], r);
    return new Method_cell_getNode(self, r, ret_types[0]);
  }

  // Other cases.
  if (self->tag == Val_Node) { // Receiver is constant
    ValNode *rec = (ValNode*)self;
    if (num_rets == 0) {
      if (num_args == 0) {
	return new Method0_0_ConstantNode(rec, m);
      }
      if (num_args == 1) {
	if (args[0]->tag == Val_Node)   // Constant argument
	  return new Method0_1C_ConstantNode(rec, m, (ValNode*)args[0]);
	else
	  // Variable argument
	  return new Method0_1F_ConstantNode(rec, m, (FutureNode*)args[0]);
      }
    }
    if (num_rets == 1) {
      find_type(results[0], r);

      if (num_args == 0) {
	return new Method1_0_ConstantNode(rec, m, r, ret_types[0]);
      }
      if (num_args == 1) {
	if (args[0]->tag == Val_Node)   // Constant argument
	  return new Method1_1C_ConstantNode(
              rec, m, (ValNode*)args[0], r, ret_types[0]);
	else
	  // Variable argument
	  return new Method1_1F_ConstantNode(
              rec, m, (FutureNode*)args[0], r, ret_types[0]);
      }
      // n arguments
      return new Method1_n_ConstantNode(
              rec, m, num_args, args, r, ret_types[0]);
    }
  }
  if (self->tag == Future_Node) { // Receiver is constant
    FutureNode *rec = (FutureNode*)self;
    if (num_rets == 0) {
      if (num_args == 0) {
	return new Method0_0_FutureNode(rec, m);
      }
      if (num_args == 1) {
	if (args[0]->tag == Val_Node)   // Constant argument
	  return new Method0_1C_FutureNode(rec, m, (ValNode*)args[0]);
	else
	  // Variable argument
	  return new Method0_1F_FutureNode(rec, m, (FutureNode*)args[0]);
      }
    }
    if (num_rets == 1) {
      find_type(results[0], r);

      if (num_args == 0) {
	return new Method1_0_FutureNode(rec, m, r, ret_types[0]);
      }
      if (num_args == 1) {
	if (args[0]->tag == Val_Node)   // Constant argument
	  return new Method1_1C_FutureNode(
              rec, m, (ValNode*)args[0], r, ret_types[0]);
	else
	  // Variable argument
	  return new Method1_1F_FutureNode(
              rec, m, (FutureNode*)args[0], r, ret_types[0]);
      }
      // n arguments
      return new Method1_n_FutureNode(
              rec, m, num_args, args, r, ret_types[0]);
    }
  }
  // XXX Generic method.
  return new MethodXNode(self, m, num_args, args, num_rets,
				    results, ret_types);
}

// Debugging code.

#if DEBUG_CONTROLS
void FutureOffsetNode::print_node() {
  fprintf(stderr, "Obj = %x, Offset = %d\n", *r, hdroff);
}

void FutureNode::print_node() {
  fprintf(stderr, "Obj = %x\n", *r);
}

void ValNode::print_node() {
  fprintf(stderr, "Value = %d\n", (long)o);
}

void Method_cell_getNode::print_node() {
  fprintf(stderr, "Method_cell_getNode\n");
}

void Method_cell_putNode::print_node() {
  fprintf(stderr, "Method_cell_putNode\n");
}

void Method0_0_ConstantNode::print_node() {
  fprintf(stderr, "Method0_0_ConstantNode, receiver = %d\n", (long)receiver);
}

void Method1_0_ConstantNode::print_node() {
  fprintf(stderr, "Method1_0_ConstantNode, receiver = %d, result = %d\n", 
	  (long)receiver, result);
}

void Method0_1C_ConstantNode::print_node() {
  fprintf(stderr, "Method0_1C_ConstantNode, receiver = %d, arg = %d\n",
	  (long)receiver, (long)arg);
}

void Method0_1F_ConstantNode::print_node() {
  fprintf(stderr, "Method0_1F_ConstantNode, receiver = %d, arg = %d",
	  (long)receiver);
  arg->print_node();
}

void Method1_1C_ConstantNode::print_node() {
  fprintf(stderr, "Method1_1C_ConstantNode, receiver = %d, arg = %d, result = %d\n",
	  (long)receiver, (long)arg, result);
}

void Method1_1F_ConstantNode::print_node() {
  fprintf(stderr, "Method1_1F_ConstantNode, receiver = %d, result = %d, arg = ",
	  (long)receiver, result);
  arg->print_node();
}

void Method1_n_ConstantNode::print_node() {
  fprintf(stderr, "Method1_n_ConstantNode, receiver = %d, result = %d, args = ",
	  (long)receiver, result);
  print_args_list(args, num_args);
}

void Methodk_n_ConstantNode::print_node() {
  fprintf(stderr, "Methodk_n_ConstantNode, receiver = %d, results = \n",
	  (long)receiver);
  print_return_list(results, num_rets);
  fprintf(stderr, "args = \n");
  print_args_list(args, num_args);
}

void Method0_0_FutureNode::print_node() {
  fprintf(stderr, "Method0_0_FutureNode, receiver: \n");
  receiver->print_node();
}

void Method1_0_FutureNode::print_node() {
  fprintf(stderr, "Method1_0_FutureNode, result = %d\n", result);
  fprintf(stderr, "receiver: ");
  receiver->print_node();
}

void Method0_1C_FutureNode::print_node() {
  fprintf(stderr, "Method0_1C_FutureNode, arg = %d\n", (long)arg);
  fprintf(stderr, "receiver: ");
  receiver->print_node();
}

void Method0_1F_FutureNode::print_node() {
  fprintf(stderr, "Method0_1F_FutureNode, arg: ");
  arg->print_node();
  fprintf(stderr, "receiver: ");
  receiver->print_node();
}

void Method1_1C_FutureNode::print_node() {
  fprintf(stderr, "Method1_1C_FutureNode, arg = %d, result = %d\n",
	  (long)arg, result);
  fprintf(stderr, "receiver: ");
  receiver->print_node();
}

void Method1_1F_FutureNode::print_node() {
  fprintf(stderr, "Method1_1F_FutureNode, result = %d, arg: ", result);
  arg->print_node();
  fprintf(stderr, "receiver: ");
  receiver->print_node();
}

void Method1_n_FutureNode::print_node() {
  fprintf(stderr, "Method1_n_FutureNode, result = %d, args: ", result);
  print_args_list(args, num_args);
  fprintf(stderr, "receiver: ");
  receiver->print_node();
}

void Methodk_n_FutureNode::print_node() {
  fprintf(stderr, "Methodk_n_FutureNode, results: \n");
  receiver->print_node();
  print_return_list(results, num_rets);
  fprintf(stderr, "receiver: ");
  receiver->print_node();
  fprintf(stderr, "args = \n");
  print_args_list(args, num_args);
}

void MethodXNode::print_node() {
  fprintf(stderr, "MethodNode:\n");
  fprintf(stderr, "  self: ");
  self->print_node();
  fprintf(stderr, "  method: %s\n", string_charp(method_name(m)));
  fprintf(stderr, "  args: ");
  print_args_list(args, num_args);
  fprintf(stderr, "  results: ");
  print_return_list(results, num_rets);
}

void IfNode::print_node() {
  fprintf(stderr, "IfNode:\n");
  fprintf(stderr, "expression:\n");
  print_tree(expr);
  fprintf(stderr, "condition:\n");
  condition->print_node();
  fprintf(stderr, "then_branch:\n");
  print_tree(then_branch);
  fprintf(stderr, "else_branch:\n");
  print_tree(else_branch);
}

void LoopNode::print_node() {
  fprintf(stderr, "LoopNode:\n");
  fprintf(stderr, "expression:\n");
  print_tree(expr);
  fprintf(stderr, "condition:\n");
  condition->print_node();
  fprintf(stderr, "body:\n");
  print_tree(body);
}

void IterNode::print_node() {
  fprintf(stderr, "IterNode:\niterator:\n");
  iterator->print_node();
  fprintf(stderr, "body:\n");
  print_tree(body);
}

void print_args_list(VarNode** l, int num_args) {
  for (int i = 0; i < num_args; i++) {
    if (l[i])
      l[i]->print_node();
  }
}

void print_return_list(int* l, int num_rets) {
  for (int i = 0; i < num_rets-1; i++)
    fprintf(stderr, "%d, ", l[i]);
  fprintf(stderr, "%d\n", l[num_rets-1]);
}

void print_tree(Node *t) {
  if (t) {
    t->print_node();
    print_tree(t->next);
  }
}

#endif  //DEBUG_CONTROLS

