/*  Copyright 1995 Barbara Liskov */

#ifndef _SHM_MACROS_H
#define _SHM_MACROS_H

/* This include files overrides the usual connection operations and
   replaces them with calls to a "ShmServer" object. It should be
   used *very* sparingly.
*/

#include "config/vdefs/SHM.h"

#if SHM
#include "shm_connect.h"
#include <assert.h>

#define connection ShmServer *
#define connection_fgetc ShmServer_fgeti
#define connection_getc ShmServer_fgeti
#define connection_fgeti ShmServer_fgeti
#define connection_fputi ShmServer_fputi
#define connection_fputc ShmServer_fputi
#define connection_putc ShmServer_fputi
#define connection_fread ShmServer_read
#define connection_fwrite ShmServer_write
#define connection_setDisp(c, x) (void)0
#define connection_fflush(x) (void)0
#define connection_close(x)  connection_putc(x,'='),x->wakeupClient(),(void)0
#define connection_resynchronize(c)  c->wait_for_immediate_flag_reset()

static inline void ShmServer_fputi(ShmServer *s, int i)
{
    s->put(i);
}

static inline int ShmServer_fgeti(ShmServer *s)
{
    return s->get();
}

static inline void ShmServer_read(ShmServer *s, void *buf, int bytes)
{
    assert((bytes & (sizeof(int) - 1)) == 0); /* Must be int-aligned */
    s->read((int *)buf, bytes/sizeof(int));
}

static inline void ShmServer_write(ShmServer *s, void const *buf, int bytes)
{
    assert((bytes & (sizeof(int) - 1)) == 0); /* Must be int-aligned */
    s->write((int const *)buf, bytes/sizeof(int));
}

#else
#error "Shouldn't have included shm.h"
#endif

#endif /* _SHM_MACROS_H */
