/* Copyright 1995 Barbara Liskov */

#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "runtime/except.h"
#include "boot/wellknown.h"
#include "types/str.h"
#include "types/string_class.h"
#include "../../config/vdefs/COMPILER.h"
#include "Compiler_class.h"
#include "compiler.h"
#include <stdio.h>

class_ CompilerC;

extern string theta_compile(FILE *src, string nm);
extern string theta_parse(FILE *src, string nm);
extern string theta_check(FILE *src, string nm);
extern string theta_show();
extern string theta_expunge();

IMPL_GET_CLASS(CompilerC)
     
struct Compilerdv_s Compiler_methods = { 
  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &CompilerC_get_class },
  Compiler_compile,
  Compiler_parse,
  Compiler_check,
  Compiler_show,
  Compiler_expunge
};


string Compiler_compile (Compiler self, string args) {
  string ret;
  FILE *src;
  char *errs;

  FIX_FAST(self,Compiler,Compiler_methods);
  FIXUPREAD(&self->hdr.inh);
  if (string_length(args) == 0) {
 	 ret = string_new("Error: file name missing");
	 return ret;
  }
  src = fopen(string_charp(args), "r");
  if (!src) {
  	ret = string_new("Error: Line   -1: Can't open file");
  	return ret;
  }
  ret = theta_compile(src, args);
  fclose(src);
  /* RESIGNAL_ANY_EXC;     Could signal not_found */
  return ret;
}

string Compiler_parse (Compiler self, string args) {
  string ret;
  FILE *src;
  char *errs;

  FIX_FAST(self,Compiler,Compiler_methods);
  FIXUPREAD(&self->hdr.inh);
  if (string_length(args) == 0) {
 	 ret = string_new("Error: file name missing");
	 return ret;
  }
  src = fopen(string_charp(args), "r");
  if (!src) {
  	ret = string_new("Error: Line   -1: Can't open file");
  	return ret;
  }
  ret = theta_parse(src, args);
  fclose(src);
  /* RESIGNAL_ANY_EXC;     Could signal not_found */
  return ret;
}

string Compiler_check (Compiler self, string args) {
  string ret;
  FILE *src;
  char *errs;

  FIX_FAST(self,Compiler,Compiler_methods);
  FIXUPREAD(&self->hdr.inh);
  if (string_length(args) == 0) {
 	 ret = string_new("Error: file name missing");
	 return ret;
  }
  src = fopen(string_charp(args), "r");
  if (!src) {
  	ret = string_new("Error: Line   -1: Can't open file");
  	return ret;
  }
  ret = theta_check(src, args);
  fclose(src);
  /* RESIGNAL_ANY_EXC;     Could signal not_found */
  return ret;
}

string Compiler_show (Compiler self) {
  string ret;

  FIX_FAST(self,Compiler,Compiler_methods);
  FIXUPREAD(&self->hdr.inh);
  ret = theta_show();
  /* RESIGNAL_ANY_EXC; */
  return ret;
}

string Compiler_expunge (Compiler self) {
  string ret;

  FIX_FAST(self,Compiler,Compiler_methods);
  FIXUPREAD(&self->hdr.inh);
  ret = theta_expunge();
  return ret;
}

#include "types/class_class.h"

DV Compiler_DH[] = { (DV)&Compiler_methods };

void initCompiler()
{
#if COMPILER
  CompilerC->dh = Compiler_DH;
  CompilerC->dhsize = 1;
#endif
}

Compiler ThetaV;

void initTheta()
{
#if COMPILER
	ThetaV = NEW(struct Compiler_s);
	init_obj_hdr_prim(&ThetaV->hdr.inh, 0, 0,
		(DV)(&Compiler_methods));
	update_wellknown(string_new("Theta"), (obj *)&ThetaV);
	exc = &exc_empty;	/* indicate old value is not good */
#endif
}
