/* Copyright 1995 Barbara Liskov */

#ifndef _COMPILER_H
#define _COMPILER_H

#include "Compiler_def.h"
#include "types/str.h"

#ifdef __cplusplus
extern "C" {
#endif


/*	Definitions of Methods on the Compiler Object 		   */

extern string Compiler_compile(Compiler self, string args);
/* Compile file name in args.  Return string containing any errors, */
/* or "ok" if no problem */

extern string Compiler_parse(Compiler self, string args);
/* Parse file name in args.  Return string containing any errors, */
/* or "ok" if no problem */

extern string Compiler_check(Compiler self, string args);
/* Typecheck file name in args.  Return string containing any errors, */
/* or "ok" if no problem */

extern string Compiler_show(Compiler self);
/* Return string showing the current environment. */

extern string Compiler_expunge(Compiler self);
/* Expunge the current environement.  Return ok. */

extern void initCompiler();
extern void initTheta();

#ifdef __cplusplus
}
#endif

#endif /* _COMPILER_H */
