// Copyright 1995 Barbara Liskov

#ifndef _CG_H
#define _CG_H
extern "C" {
extern void do_type_file(string filename, string tname, 
			objtype t, ParseNode *pn);
extern void begin_class_file(string filename, string tname, 
			string cname, objtype t, ParseNode *pn);
extern void end_class_file();
extern void begin_rtn_file(string filename, ParseNode *pn, string nm,
			method m);
extern void end_rtn_file();
extern void begin_pth_file(string nm);
extern void extend_pth_file(ParseNode *pn);
extern void end_pth_file();
extern void begin_support_files(string nm);
extern void extend_support_files(ParseNode *pn);
extern void end_support_files();
extern void ps(char *s);
extern void psc(const char *s);
extern void pstr(string s);
extern void pint(int i);
extern void ptname();
extern void pcname();
extern void pmsig(method m);
extern void prsig(method m);
extern void pmsigcast(method m, const char *name);
extern bool is_ivar(Expr *prim, string nm, const char **c_name);
extern bool is_method(string nm);
extern Decl *find_ivar_in_dl(string m_name, ParseNodeList *dl);
extern objtype the_obj;
extern class_ save_stripped_class;
extern void save_class(ClassDef *cd);
extern void clear_class();
extern ClassDef *get_save_class();
extern void save_rdef(RoutineDef *rdef);
extern void clear_rdef();
extern string current_return_type();
extern void srch_pn_for_types(ParseNode *pn);
extern void clear_types();
extern void output_types();
extern void output_pts_externs();
extern void output_pts_decls();
extern void output_pts_data();
extern void output_pts_instns();
extern void clear_pts();
extern void clear_global_pts();
extern void decl_temps(ParseNode *pn);
extern void decl_locals(ParseNode *pn);
extern void srch_pnl_for_locals(ParseNodeList *pnl);
extern void srch_pn_for_locals(ParseNode *pn);
extern void srch_pnl_for_temps(ParseNodeList *pnl);
extern void srch_pn_for_temps(ParseNode *pn);
extern void process_locals(TypeSpec *ts, ParseNodeList *pnl);
extern void process_local(TypeSpec *ts, Id *id);
extern void process_temps(ParseNodeList *pnl);
extern void process_temp(Expr *ex);
extern bool simple_expr(Expr *ex);
extern void save_local(string typ, string id);
extern void clear_locals();
extern void output_locals();
extern void output_local(string typ, string id);
extern void save_temp(string typ);
extern void clear_temps();
extern void reset_temps();
extern void output_temps();
extern void output_temp(string typ, char *id);
extern string get_next_temp();
extern string get_next_temp_and_type(string *types_name);
extern string simple_type_name(string type_name);
extern ParseNodeList *exprs_preprocess(ParseNodeList *exl);
extern Expr *expr_preprocess(Expr *ex);
extern void eq_clear();
extern void eq_emit(Equate *eq);
extern void eq_save(Equate *eq);
extern void eq_emit_saved();
extern void expr_emit(Expr *ex);
extern void exprs_emit(ParseNodeList *exl);
extern ParseNode *inv_preprocess(Invoc *inv);
extern void pn_emit(ParseNode *inv);
extern void inv_emit(Invoc *inv);
extern void inv_check_emit(Invoc *inv);
extern void pn_check_emit(ParseNode *pn);
extern bool base_inv_emit(Invoc *inv, DotExpr *de);
extern void decls_emit(ParseNodeList *decls);
extern void decl_emit(Decl *decl);
extern void idorivar_emit(IdOrIvar *idv);
extern void inc_ind();
extern void dec_ind();
extern void ind();
extern void loop_init();
extern void loop_enter();
extern void loop_end_label();
extern void  loop_goto_end();
extern void loop_exit();
extern void exc_init();
extern void exc_enter();
extern void exc_exit();
extern int  exc_current();
extern void exc_label();
extern void exc_end_label();
extern void exc_goto_end();
extern void exc_goto_exc(bool tab);
extern bool exc_scope_exists();
extern bool inv_signalling(Invoc *inv, type *tp);
extern bool inv_parmd(method m);
extern bool inv_result_parmd(ParseNode *pn);
extern bool parmd_site();
extern ptype instn_ptype(instn);
extern instn type_as_instn(type);
extern void fix_fix(DotExpr *de);
extern void fix_read(string nm, type t, char *c_name);
extern void fix_write(ParseNode *pn);
extern void fix_clear();
extern void fix_new_scope();
extern void fix_end_scope();
extern objtype stripped_class(objtype ot);
extern void do_supers(objtype ot, char *ditty);
extern void do_supersm1(objtype ot, char *ditty);
extern bool anyize(ParseNode *pn, Expr *ex);
extern bool anyize_it(Expr *ex);
extern bool assn_cast_site(ParseNode *lpn, Expr *rhex);
extern bool is_object(ParseNode *pn);
extern bool cg_rhs;
extern type get_one_type(TypeInterface *ti, int lineno);
extern string type2nm(type t);
extern void mod_impls_save(ImplModule *im);
extern void mod_impls_clear();
extern bool mod_impls_member(RoutineDef *rd);
extern void do_closing(RoutineDef *rd);
extern void opt_inv_temps(Invoc *inv);
extern bool opt_declforstmt(DeclForStmt *dfs);
extern bool opt_forstmt(ForStmt *fs);
extern bool forced_prep();
extern void enter_forced_prep();
extern void leave_forced_prep();
}
#endif /* _CG_H */
