// Copyright 1995 Barbara Liskov

#ifdef __cplusplus
extern "C" {
#endif
#include "parse.h"
#include <stdio.h>
#include "string.h"
#include "my_string.h"
#include <unistd.h>
#include <ctype.h>
#include "types/objtype_class.h"
#include "types/vec.h"
#include "types/method.h"
#include "types/ptype.h"
#include "types/class.h"
#include "types/class_class.h"
#include "types/class_instn.h"
#include "types/class_instn_class.h"
#include "types/vec_instns.h"
#ifdef __cplusplus
}
#endif

#include "cg.h"

/*
	Various routine to process expressions.
*/

ParseNodeList *exprs_preprocess(ParseNodeList *exprs)
{
   ParseNodeList *new_exprs = new ParseNodeList();
   if (exprs) for (Pix p = exprs->first(); p ; exprs->next(p)){
	Expr *ex = (Expr *)(*exprs)(p);
	Expr *ex2 = expr_preprocess(ex);
	new_exprs->append(ex2);
	}
   return new_exprs;
   }

bool cg_rhs = TRUE;

Expr *expr_preprocess(Expr *ex)
{
   switch (ex->tag()) {
	case Expr::NilT: {
		return ex;
		}
	case Expr::LiteralT: {
		return ex;
		}
	case Expr::InstantiationT: {
		// temporary
		cmp_err("expr_preprocess: instantiation", 0);
		return NULL;
		}
	case Expr::DotExprT: {
		DotExpr *de = (DotExpr *)ex;
		Expr *prim = de->get_primary();
		enter_forced_prep();
		Expr *new_prim = expr_preprocess(prim);
		leave_forced_prep();
		DotExpr *new_de = new DotExpr(new_prim, de->get_id());
		new_de->type_ = de->type_;
		fix_fix(new_de);
		return new_de;
		}
	case Expr::SuperIdT: {
		// temporary
		cmp_err("expr_preprocess: superid", 0);
		return NULL;
		}
	case Expr::SelfT: {
		return ex;
		}
	case Expr::NewT: {
		// temporary
		cmp_err("expr_preprocess: new", 0);
		return NULL;
		}
	case Expr::ArrayRefT: {
		// temporary
		cmp_err("expr_preprocess: arrayref", 0);
		return NULL;
		}
	case Expr::InvocExprT: {
		InvocExpr *inve = (InvocExpr *)ex;
		Invoc *inv = inve->get_invoc();
		ParseNode *pn = inv_preprocess(inv);
		switch (pn->tag()) {
			case ParseNode::InvocT: {
				Invoc *new_inv = (Invoc *)pn;
				InvocExpr *new_inve = new InvocExpr(new_inv);
				new_inve->type_ = inve->type_;
				return new_inve;
				}
			case ParseNode::ExprT: {
				Expr *e = (Expr *)pn;
				if (e->tag() != Expr::IdExprT) {
					cmp_err("expr_preprocess: inv",0);
					return NULL;
					}
				IdExpr *ide = (IdExpr *)e;
				return ide;
				}
			}
		}
	case Expr::BindingExprT: {
		// temporary
		cmp_err("expr_preprocess: binding", 0);
		return NULL;
		}
	case Expr::SelectorConstrT: {
		SelectorConstr *sc = (SelectorConstr *)ex;
		// do allocation
		string types_name;	// more like class name...
		string tmp = get_next_temp_and_type(&types_name);
		types_name = simple_type_name(types_name);
		if (string_equal(types_name, string_new("maybe"))) {
			FieldInit *fi = (FieldInit *)(sc->get_fields()
								->front());
			Expr *new_ex = expr_preprocess(fi->get_expr());
			bool full = string_equal(fi->get_id()->get_id(),
						string_new("full"));
			ind();
			pstr(tmp);
			ps(" = (");
			pstr(types_name);
			ps(")(");
			if (full) ps("maybe_make(0, ");
			else ps("maybe_none(0, empty_");
			pstr(type2nm(sc->get_type()->get_type()));
			ps("V");
			if (full) {
				ps(", PV(");
				expr_emit(new_ex);
				ps(")");
				}
			ps("));\n");
			}
		else {
			bool select = string_equal(types_name, string_new("record"))||
			      string_equal(types_name, string_new("struct"))||
			      string_equal(types_name, string_new("oneof")) ||
			      string_equal(types_name, string_new("variant"));
			ind();
			pstr(tmp);
			ps(" = (");
			pstr(types_name);
			ps(")NEW(struct ");
			pstr(types_name);
			ps("_s);\n");
			ind();
			ps("init_obj_hdr((obj)");
			pstr(tmp);
			ps(", ");
			pstr(types_name);
			ps("V);\n");
			// initialize fields
			ParseNodeList *pnl = sc->get_fields();
			if (pnl) for (Pix p = pnl->first(); p; pnl->next(p)) {
				// this isn't quite right if several fields can
				//	have the same value
				FieldInit *fi = (FieldInit *)(*pnl)(p);
				Expr *new_ex = expr_preprocess(fi->get_expr());
				ind();
				if (!select) {
					ps("((");
					pstr(types_name);
					ps("_C)");
					}
				pstr(tmp);
				if (!select) ps(")");
				ps("->");
				pstr(fi->get_id()->get_id());
				ps(" = ");
				bool needs_cast = assn_cast_site(fi->get_id(), new_ex);
				bool is_any = anyize(fi->get_id(), new_ex);
				expr_emit(new_ex);
				if (is_any) ps(")");
				if (needs_cast) ps(")");
				ps(";\n");
				}
			}
		// return temp used for allocation	
		IdExpr *ide = new IdExpr(new Id(tmp));
		ide->type_ = sc->type_;
		return ide;
		return NULL;
		}
	case Expr::ArrayConstrT: {
		// temporary
		cmp_err("expr_preprocess: arrayconstr", 0);
		return NULL;
		}
	case Expr::IdExprT: {
		if (cg_rhs) {
		    const char *dummy = "";
		    IdExpr *ide = (IdExpr *)ex;
		    string nm = ide->get_id()->get_id();
		    bool ivar = is_ivar(0, nm, &dummy);
		    if (ivar) {
			type t = ide->get_type()->get_type();
			fix_read(nm, t, (char*)dummy);
			}
		    }
		return ex;
		}
	case Expr::BinaryT: {
		Binary *b = (Binary *)ex;
		Expr *ex1 = expr_preprocess(b->get_op1());
		if (simple_expr(b->get_op2())) {
		    Binary *b2;
		    if (b->tag() == Binary::AndT)
		    	b2 = new Binary(Binary::AndT, ex1, b->get_op2());
		    else b2 = new Binary(Binary::OrT, ex1, b->get_op2());
		    b2->type_ = b->type_;
		    return b2;
		    }
		else {
	            string tmp = get_next_temp();
		    ps("\n");
		    ind();
		    if (b->tag() == Binary::AndT) {
		    	ps("if (");
		    	expr_emit(ex1);
		    	ps(") {\n");
			inc_ind();
			ind();
		    	Expr *ex2 = expr_preprocess(b->get_op2());
		    	pstr(tmp);
		    	ps(" = ");
		    	expr_emit(ex2);
		    	ps(";\n");
			ind();
			ps("}\n");
			dec_ind();
		    	ind();
		    	ps("else ");
		    	pstr(tmp);
		    	ps(" = FALSE;\n");
			}
		    else {
		    	ps("if (");
		    	expr_emit(ex1);
		    	ps(") ");
		    	pstr(tmp);
		    	ps(" = TRUE;\n");
		    	ind();
		    	ps("else {\n");
		    	inc_ind();
			ind();
		    	Expr *ex2 = expr_preprocess(b->get_op2());
		    	ind();
		    	pstr(tmp);
		    	ps(" = ");
		    	expr_emit(ex2);
		    	ps(";}\n");
		    	dec_ind();
			}
		    IdExpr *ide = new IdExpr(new Id(tmp));
		    ide->type_ = b->type_;
		    return ide;
		    }
		}
	case Expr::UnaryT: {
		// shouldn't occur
		cmp_err("expr_preprocess: unary", 0);
		return NULL;
		}
	case Expr::BracketRefT: {
		BracketRef *br = (BracketRef *)ex;
		bool parmd = inv_result_parmd(ex);
		Expr *new_prim = expr_preprocess(br->get_primary());
		type t = get_one_type(new_prim->get_type(), 
				new_prim->get_line());
		ParseNodeList *new_exprs = exprs_preprocess(br->get_exprs());
		string tname;
		string tmp = get_next_temp_and_type(&tname);
		if (cg_rhs) {
			ind();
			pstr(tmp);
			ps(" = ");
			if (parmd) {
				ps("UNPV(");
				pstr(tname);
				ps(", ");
				}
			if (t && string_equal(
					string_new("string"), type_name(t))) {
				ps("string_fetch_(");
				}
			else {
				ps("(*");
				expr_emit(new_prim);
				ps(")");
				ps("->fetch(");
				}
			// if (parmd) ps("PBLOCK, ");
			expr_emit(new_prim);
			ps(", ");
			exprs_emit(new_exprs);
			if (parmd)
				ps(")");
			ps(");\n");
			// possibly make this optional
   			ind();
   			ps("if(exc) ");
   			exc_goto_exc(FALSE);
			IdExpr *ide = new IdExpr(new Id(tmp));
			ide->type_ = br->type_;
			return ide;
			}
		return NULL;
		}
	case Expr::BraceRefT: {
		// temporary
		cmp_err("expr_preprocess: braceref", 0);
		return NULL;
		}
	}
   }

ParseNode *inv_preprocess(Invoc *inv)
{
   RoutineId* rid = inv->get_routineId();
   RoutineId* nrid;
   switch (rid->tag()) {
	case RoutineId::SimpleRoutineIdT: {
		SimpleRoutineId *srid = (SimpleRoutineId *)rid;
		Expr *ex = srid->get_primary();
		Expr *new_ex = expr_preprocess(ex);
		nrid = new SimpleRoutineId(new_ex);
		nrid->type_ = srid->type_;
		break;
		}
	case RoutineId::ComplexRoutineIdT: {
		ComplexRoutineId *crid = (ComplexRoutineId *)rid;
		Expr *ex = crid->get_primary();
		ParseNodeList *actuals = crid->get_parms();
		Expr *new_ex = expr_preprocess(ex);
		nrid = new ComplexRoutineId(new_ex, actuals);
		nrid->type_ = crid->type_;
		break;
		}
	default: {
		cmp_err("inv_preprocess ignoring complex rid or superc rid",
			inv->get_line());
		}
	}
   ParseNodeList *exprs = inv->get_exprs();
   ParseNodeList *new_exprs = exprs_preprocess(exprs);
   Invoc *new_inv = new Invoc(nrid, new_exprs, 0);
   new_inv->type_ = inv->type_;
   type t;
   // 9/22/95: added test on t, because inv_signalling now returns true if
   //			inv signals and need to test t to see if there's a ret val.
   if ((inv_signalling(new_inv, &t) || forced_prep()) && t) {
	string temp = get_next_temp();
	ind();
	pstr(temp);
	ps(" = ");
	inv_emit(new_inv);
	ps(";\n");
	inv_check_emit(new_inv);
	Expr *new_id = new IdExpr(new Id(temp));
	new_id->type_ = inv->type_;
	return new_id;
	}
   else {
	return new_inv;
	}
   }

void pn_emit(ParseNode *pn)
{
	switch (pn->tag()) {
		case ParseNode::InvocT: {
			Invoc *inv = (Invoc *)pn;
			inv_emit(inv);
			break;
			}
		case ParseNode::ExprT: {
			Expr *ex = (Expr *)pn;
			expr_emit(ex);
			break;
			}
		default: {
			cmp_err("Unexpected node in pn_emit", 0);
			}
	}
   }

static inside_inv = FALSE;
static method method_being_invoked;
static int nth_expr = 0;

bool parmd_site()
{

// The purpose of this routine is to determine whether the expr
//	about to be emitted should be converted to a pval.
//	This is true, for instance, for the store method of of
//	an array.

// if the type of the nth_expr arg of current method is derived from
//	a parameter return true
type slft;
fevalue tgm_ret[2];

	if (inside_inv == 0) return FALSE;
	slft = method_being_invoked->self_type;
        if (!slft) return FALSE;	// may be hiding bugs
	ptype pt = 0;
	if (type_kind(slft) == INSTN_KIND) {
		instn ins = type_as_instn(slft);
		if (ins) pt = instn_ptype(ins);
		}
	else if (type_kind(slft) == CLASS_INSTN_KIND) {
		class_instn ci = type_as_class_instn(slft);
		if (ci) pt = ci->hdr.methods->get_ptype(ci);
		}
	if (pt == 0) return FALSE;
	string nm = method_being_invoked->name;
	RESET_EXC
	getMethod(type_as_objtype(ptype_as_type(pt)), tgm_ret, nm);
	CATCH { return FALSE; }
	method m = (method)tgm_ret[0].o;
	vec args = m->arguments;
	formal f = UNPV(formal, vec_fetch(args, nth_expr));
	type ft = f->t;
	if (type_kind(ft) == PARAM_KIND) return TRUE;
	return FALSE;
	}

bool anyize_site(Expr *ex)
{
// The purpose of this routine is to determine whether the expr
//	about to be emitted should be converted to an any.

// if the type of the nth_expr arg of current method is an any
//	anyize it (except if it's already an any)

	// ? appropriate?
	if (inside_inv == 0) return FALSE;

	vec args = method_being_invoked->arguments;
	formal f = UNPV(formal, vec_fetch(args, nth_expr));
	type ft = f->t;
	if (type_as_objtype(ft) == Any) return anyize_it(ex);
	if (!strcmp(string_charp(method_being_invoked->name), "same_object"))
			return anyize_it(ex);
	return FALSE;
	}

bool cast_site(Expr *ex)
{
// The purpose of this routine is to determine whether the expr
//	about to be emitted should be cast to some other type.

// if the type of ex is a class and the method is public,
//	the arg should be cast to the
//	corresponding type.........

	// ? appropriate?
	if (inside_inv == 0) return FALSE;

	TypeInterface *ti = ex->get_type();
	type t = ti->get_type();
	if (!t) {
		vec v = ti->get_mult();
		if (vec_length(v) > 0) {
			t = UNPV(type, vec_fetch(v, 0));
			}
		}
	if (!t) return FALSE;	// possibly simplistic
	RESET_EXC
	class_ c = type_as_class(t);
	CATCH { return FALSE; }
	else {
		vec args = method_being_invoked->arguments;
		formal f = UNPV(formal, vec_fetch(args, nth_expr));
		type ft = f->t;
		if (type_as_objtype(ft) == Any) return FALSE;
		string ftnm = type_name(ft);
		if (t && string_equal(ftnm, type_name(t))) return FALSE;
		ps("((");
		pstr(type_name(ft));
		ps(") ");
		return TRUE;
	     }
	}

bool assn_cast_site(ParseNode *pn, Expr *rhex)
{
    type lt = 0;
    switch (pn->tag()) {
      case ParseNode::ExprT: {
	Expr *lhex = (Expr *)pn;
	lt = get_one_type(lhex->get_type(), lhex->get_line());
	break;
	}
      case ParseNode::DeclT: {
	Decl *d = (Decl *)pn;
	TypeInterface *ti = pn->get_type();
	lt = get_one_type(ti, d->get_line());
	break;
 	}
      case ParseNode::IdT: {
	Id *id = (Id *)pn;
	TypeInterface *ti = id->get_type();
	lt = get_one_type(ti, pn->get_line());
	break;
	}
     }
     type rt = 0;
     if (rhex) get_one_type(rhex->get_type(), rhex->get_line());

// so we already know that rt isSubtype of lt, but
//	we need to figure out if they are exactly the
//	same type or not.  if not, a cast needs to be done.
//	so, emit the cast if necessary and return the bool
	if (!lt) {
		cmp_err("Missing type info", rhex->get_line());
		return FALSE;
		}
	if (rt && isSubtype(lt, rt)) return FALSE;
	ps("((");
	pstr(simple_type_name(type_name(lt)));
	ps(")");
	return TRUE;
   }

void emit_supers(Expr *prim, string mname, const char **casting)
{
    /* find objtype (if any) for private search */
    objtype ot = 0;
    type t = 0;
    ClassDef *save_cd = get_save_class();
    if (prim)  {
	t = get_one_type(prim->get_type(), prim->get_line());
        if (!t) {
            cmp_err("Losing in emit_supers (1)", prim?prim->get_line():0);
	    return;
	    }
        if (save_cd && (t == save_cd->get_type()->get_type())) 
			ot = class_as_objtype(save_stripped_class);
	else ot = type_as_objtype(t);
	}
    else {
	if (!save_cd) {
           cmp_err("Losing in emit_supers (2)", prim?prim->get_line():0);
	   return;
	   }
	t = save_cd->get_type()->get_type();
	ot = class_as_objtype(save_stripped_class);
	}

    /* look for private method if ot exists */
    if (ot)
	{
	vec save_supers = ot->supertypes_;
    	ot->supertypes_ = make_vec_simple(Type, 0);
    	fevalue tgm_ret[2];
	RESET_EXC;
    	getMethod(ot, tgm_ret, mname);
    	CATCH {ot->supertypes_ = save_supers; exc = EXC_NONE;}
    	else {ot->supertypes_ = save_supers; return;}
	}

    /* this method belongs to the supertype (only appears to be one of them) */
    ps("super.");
    type st = 0;
    if (t) {
	ot = type_as_objtype(t);
	if (ot->supertypes_ && vec_length(ot->supertypes_)) {
		st = UNPV(type, vec_fetch(ot->supertypes_, 0));
		*casting = string_charp(type_name(st));
		}
    	else cmp_err("Losing in emit_supers (3)", prim?prim->get_line():0);
	}
    else cmp_err("Losing in emit_supers (4)", prim?prim->get_line():0);
    }

string parms2nm(ParseNodeList *l);
string crid2instn(ComplexRoutineId *crid)
{
    // Completely arbitrary == Total Hack...
    string nm = string_empty();
    Expr *ex = crid->get_primary();
    switch (ex->tag()) {
	case Expr::IdExprT: {
		IdExpr *ide = (IdExpr *)ex;
		nm = ide->get_id()->get_id();
		if (string_equal(nm, string_new("array_new")))
			nm = string_new("array");
		if (string_equal(nm, string_new("vector_fill")))
			nm = string_new("vector");
		if (string_equal(nm, string_new("vector_create")))
			nm = string_new("vector");
		if (string_equal(nm, string_new("sequence_create")))
			nm = string_new("sequence");
		break;
		}
	default: {
		cmp_err("crid2instn: unexpected expr", crid->get_line());
		}
	}
    ActualParm *ap = (ActualParm*)crid->get_parms()->front();
    TypeInterface *ti = ap->get_type();
    type t = ti->get_type();
    nm = string_concat(nm, string_concat(string_new("_OF_"), type2nm(t)));
    return nm;
    }

void inv_emit(Invoc *inv)
{
   RoutineId* rid = inv->get_routineId();
   Expr *prim = NULL;
   Id *meth = NULL;
   method m = rid->get_type()->get_method();
   bool is_meth = FALSE;
   bool is_parmd = FALSE;
   bool parmd_result = inv_result_parmd(inv);
   if (parmd_result) {
	ps("UNPV(");
	pstr(simple_type_name(type_name(UNPV(type, vec_fetch(m->returns, 0)))));
	ps(", ");
	}
   const char *casting = 0;
   string instn_nm = 0;
   switch (rid->tag()) {
	case RoutineId::SimpleRoutineIdT: {
		SimpleRoutineId *srid = (SimpleRoutineId *)rid;
		Expr *ex = srid->get_primary();
		m = srid->get_type()->get_method();
   		is_parmd = inv_parmd(m);
		switch (ex->tag()) {
		    case Expr::DotExprT: {
			DotExpr *de = (DotExpr *)ex;
			if (base_inv_emit(inv, de)) return;
			prim = de->get_primary();
			meth = de->get_id();
			ps("(*");
			expr_emit(prim);
			ps(")");
			ps("->");
			string mname = meth->get_id();
			emit_supers(prim, mname, &casting);
			pstr(mname);
			break;
			}
		   case Expr::IdExprT: {
			IdExpr *ide = (IdExpr *)ex;
			string iname = ide->get_id()->get_id();
			is_meth = is_method(iname);
			if (is_meth) {
				ps("(*self");
				ps(")");
				ps("->");
				emit_supers(0, iname, &casting);
				}
			expr_emit(ex);
			break;
			}
		   default: {
			cmp_err("inv_emit not dealing", ex->get_line());
			}
		   }
		break;
		}
	case RoutineId::ComplexRoutineIdT: {
		ComplexRoutineId *crid = (ComplexRoutineId *)rid;
		m = crid->get_type()->get_method();
		if (m->parameterized) instn_nm = crid2instn(crid);
		Expr *ex = crid->get_primary();
		expr_emit(ex);
		// probably needs work to do something about actuals
		break;
		}
	default: {
		cmp_err("inv_emit ignoring complex rid or superc rid",
			inv->get_line());
		}
	}
   ps("(");
   // if (is_parmd) ps("PBLOCK, ");
   /* may need casting here for prim or self... */
   if (casting) { ps("(("); psc(casting); ps(")"); }
   if (prim) expr_emit(prim);
   else if (is_meth) ps("self");
   else {
	ps("0");
	if (instn_nm) {
		ps(", ");
		pstr(instn_nm);
		ps("V");
		}
	}
   if (casting) ps(")");
   ParseNodeList *exprs = inv->get_exprs();
   if (exprs && exprs->length() > 0) ps(", ");
   method_being_invoked = m;
   inside_inv = TRUE;
   exprs_emit(exprs);
   inside_inv = FALSE;
   ps(")");
   if (parmd_result) ps(")");
   }

void inv_check_emit(Invoc *inv)
{
   type dummy;
   if (inv_signalling(inv, &dummy)) {
   	ind();
   	ps("if(exc) ");
   	exc_goto_exc(FALSE);
	}
   }

void pn_check_emit(ParseNode *pn)
{
   // can arrive here with either Invoc or IdExpr
   // 	don't do anything for IdExpr
   switch (pn->tag()) {
	case ParseNode::InvocT: {
		Invoc *inv = (Invoc *)pn;
		inv_check_emit(inv);
		}
	}
   }

bool base_inv_emit(Invoc *inv, DotExpr *de)
{
	TypeInterface *ti = de->get_primary()->get_type();
	type t = get_one_type(ti, de->get_line());
	if (!t) return FALSE;
	string tn = type_name(t);
	if (string_equal(tn, string_new("int")) ||
			string_equal(tn, string_new("char")) ||
			string_equal(tn, string_new("bool")) ||
			string_equal(tn, string_new("real")) ||
			string_equal(tn, string_new("null")) ||
			// Technically, string doesn't need to be here
			//	except for maybe some inconsistency of
			//	the string*.h files w.r.t. assumptions
			//	about whether foo points to methods or class...
			string_equal(tn, string_new("string"))
			) {
		pstr(tn);
		ps("_");
		string enm = de->get_id()->get_id();
		pstr(enm);
		// Yuck...
		if (string_equal(tn, string_new("string")) &&
			(string_equal(enm, string_new("empty")) ||
			 string_equal(enm, string_new("fetch")))) ps("_");
		ps("(");
		expr_emit(de->get_primary());
		ParseNodeList *exprs = inv->get_exprs();
		if (exprs && exprs->length()) {
			ps(", ");
			exprs_emit(inv->get_exprs());
			}
		ps(")");
		return TRUE;
	     	}
	return FALSE;
	}

void exprs_emit(ParseNodeList *exprs)
{
bool do_comma = FALSE;

   method save_method = method_being_invoked;
   int save_nth_expr = 0;
   if (exprs) for (Pix p = exprs->first(); p ; exprs->next(p)) {
	nth_expr = save_nth_expr;
	method_being_invoked = save_method;
	if (do_comma) ps(", ");
	Expr *ex = (Expr *)(*exprs)(p);
	bool close_cast = cast_site(ex);
	bool close_any = anyize_site(ex);
	bool do_pv = parmd_site();
   	if (do_pv) ps("PV(");
	expr_emit(ex);
   	if (do_pv) ps(")");
	if (close_any) ps(")");
	if (close_cast) ps(")");
	do_comma = TRUE;
	save_nth_expr++;
	}
   }

extern char *print_version(char c);
extern void print_version(string s);

void expr_emit(Expr *ex)
{
   if (ex) switch (ex->tag()) {
	case Expr::NilT: {
		ps("0");
		break;
		}
	case Expr::LiteralT: {
	    Literal *lit = (Literal *)ex;
	    switch (lit->tag()) {
		case Literal::IntLiteralT: {
			IntLiteral *i = (IntLiteral *)lit;
			char oneint[30];
			sprintf(oneint, "%d", i->get_i());
			ps(oneint);
			break;
			}
		case Literal::BoolLiteralT: {
			BoolLiteral *b = (BoolLiteral *)lit;
			if (b->get_b()) ps("TRUE"); else ps("FALSE");
			break;
			}
		case Literal::CharLiteralT: {
			CharLiteral *c = (CharLiteral *)lit;
			char *pchar = print_version(c->get_c());
			ps("'");
			ps(pchar);
			ps("'");
			break;
			}
		case Literal::StringLiteralT: {
			StringLiteral *s = (StringLiteral *)lit;
			ps("string_newn(\"");
			print_version(s->get_s());
			ps("\",");
			pint(string_length(s->get_s()));
			ps(")");
			break;
			}
		case Literal::RealLiteralT: {
			RealLiteral *r = (RealLiteral *)lit;
			char onereal[30];
			sprintf(onereal, "%f", r->get_r());
			ps(onereal);
			break;
			}
		   }
		}
	case Expr::InstantiationT: {
		break;
		}
	case Expr::DotExprT: {
		DotExpr *de = (DotExpr *)ex;
		Expr *prim = de->get_primary();
		string nm = de->get_id()->get_id();
		const char *c_name = "";
		bool ivar = is_ivar(prim, nm, &c_name);
		if (ivar) { ps("(("); psc(c_name); ps("_C)"); }
		expr_emit(prim);
		if (ivar) ps(")");
		ps("->");
		pstr(nm);
        	break;
		}
	case Expr::SuperIdT: {
		break;
		}
	case Expr::SelfT: {
		ps("self");
		break;
		}
	case Expr::NewT: {
		break;
		}
	case Expr::ArrayRefT: {
		break;
		}
	case Expr::InvocExprT: {
		InvocExpr *inv = (InvocExpr *)ex;
		inv_emit(inv->get_invoc());
		break;
		}
	case Expr::BindingExprT: {
		break;
		}
	case Expr::SelectorConstrT: {
		break;
		}
	case Expr::ArrayConstrT: {
		break;
		}
	case Expr::IdExprT: {
		const char *c_name = "";
		IdExpr *ie = (IdExpr *)ex;
		string nm  = ie->get_id()->get_id();
		bool ivar = is_ivar(0, nm, &c_name);
		if (ivar) {
			ps("((");
			psc(c_name);
			ps("_C)self)->");
			}
		pstr(nm);
		break;
		}
	case Expr::BinaryT: {
		Binary *b = (Binary *)ex;
		if (b->tag() == Binary::AndT) {
		    ps("(");
		    expr_emit(b->get_op1());
		    ps(" ? ");
		    expr_emit(b->get_op2());
		    ps(" : FALSE)");
		    }
		else {
		    ps("(");
		    expr_emit(b->get_op1());
		    ps(" ? TRUE : ");
		    expr_emit(b->get_op2());
		    ps(")");
		    }
		break;
		}
	case Expr::UnaryT: {
		// shouldn't occur
		break;
		}
	case Expr::BracketRefT: {
		break;
		}
	case Expr::BraceRefT: {
		break;
		}
	}
   }


/* seems unused... */
void decls_emit(ParseNodeList *decls)
{
   bool do_comma = FALSE;
   if (decls) for (Pix p = decls->first(); p ; decls->next(p)) {
	if (do_comma) ps(", ");
	Decl *d = (Decl *)(*decls)(p);
	decl_emit(d);
   	do_comma = TRUE;
	}
   }

void decl_emit(Decl *d)
{
   bool do_comma = FALSE;
   switch (d->tag()) {
	case Decl::RegDeclT: {
		RegDecl *rd = (RegDecl *)d;
   		ParseNodeList *ids = rd->get_ids();
   		if (ids) for (Pix p = ids->first(); p ; ids->next(p)) {
			const char *dummy = "";
			Id *id = (Id *)(*ids)(p);
			/* seems a little wierd to me... */
			/* shouldn't be decling an ivar... */
			if (is_ivar(0, id->get_id(), &dummy)) fix_write(id);
			}
   		if (ids) for (Pix p = ids->first(); p ; ids->next(p)) {
			if (!do_comma) ind();
			if (do_comma) ps(", ");
			Id *id = (Id *)(*ids)(p);
			pstr(id->get_id());
   			do_comma = TRUE;
			}
		break;
		}
	case Decl::VarArgsDeclT: {
		}
	}
   }

void idorivar_emit(IdOrIvar *idv)
{
   Expr *ex = idv->get_primary();
   if (ex != 0) {
	cmp_err("Time to fix IdOrIvar", idv->get_line());
	}
   Id *id = idv->get_id();
   pstr(id->get_id());
   }

#define MAXEQ 500
static int eq_saved_count = 0;
static Equate *eq_saved[MAXEQ];

void eq_clear()
{
   eq_saved_count = 0;
   }

void eq_save(Equate *eq)
{
   if(eq_saved_count >= MAXEQ) {
	th_fail("cg_expr.cc: increase MAXEQ");
	}
   eq_saved[eq_saved_count] = eq;
   eq_saved_count++;
   }

void eq_emit_saved()
{
int i;
	for (i = 0; i < eq_saved_count; i++) {
		eq_emit(eq_saved[i]);
		}
  }

void eq_emit(Equate *eq)
{
   switch (eq->tag()) {
	case (Equate::ExprEquateT): {
		ExprEquate *eeq = (ExprEquate *)eq;
		ps("#define ");
		pstr(eeq->get_id()->get_id());
		ps(" ");
		expr_emit(eeq->get_expr());
		ps("\n");
		break;
		}
	}
   }


void print_version(string s)
{
int size = string_length(s);
char c;

	for (int i = 0; i < size ; i++) {
		c = string_charp(s)[i];
		ps(print_version(c));
		}
	}

char *print_version(char c)
{
char chars[8];
int temp;
	chars[0] = '\\';
	if (isprint(c)) {
		if (c == '"') {
			chars[0] = '\\';
			chars[1] = c;
			chars[2] = '\0';
			return chars;
			}
		if (c == '\'' || c == '\\') {
			chars[1] = c;
			chars[2] = '\0';
			return chars;
			}
		chars[0] = c;
		chars[1] = '\0';
		return chars;
		}
	if (c == '\0') {
		chars[1] = '0';
		chars[2] = '0';
		chars[3] = '0';
		chars[4] = '\0';
		return chars;
		}
	temp = c;
	temp &= 0xff;
	sprintf(&chars[1], "%-3.3o", temp);
	return chars;
	}
