// Copyright 1995 Barbara Liskov


#include "parse.h"
#include "my_string.h"
#include "cg.h"
#include "types/type.h"
#include "types/class.h"
#include "types/objtype_class.h"

void decl_locals(ParseNode *pn)
{
   clear_locals();
   srch_pn_for_locals(pn);
   output_locals();
   }

void srch_pnl_for_locals(ParseNodeList *pnl)
{
   if (pnl) for (Pix p = pnl->first(); p ; pnl->next(p)){
	ParseNode *pn = (ParseNode *)(*pnl)(p);
	srch_pn_for_locals(pn);
	}
   }

void srch_pn_for_locals(ParseNode *pn)
{
   if (pn) switch (pn->tag()) {
	case ParseNode::ImplEltT: {
		ImplElt *ie = (ImplElt *)pn;
		switch (ie->tag()) {
			case ImplElt::RoutineDefT: {
				RoutineDef *rd = (RoutineDef *)pn;
				srch_pn_for_locals(rd->get_body());
				break;
				}
			case ImplElt::ClassDefT: {
				ClassDef *cd = (ClassDef *)pn;
				// srch_pnl_for_locals(cd->get_classElts());
				break;
				}
			}
		break;
		}
	case ParseNode::MethodOrOpDefT: {
		MethodOrOpDef *mopd = (MethodOrOpDef *)pn;
		srch_pn_for_locals(mopd->get_routineDef());
		break;
		}
	case ParseNode::DeclT: {
		Decl *d = (Decl *)pn;
		TypeSpec *ts;
		switch (d->tag()) {
			case Decl::RegDeclT: {
				RegDecl *rd = (RegDecl *)d;
				ParseNodeList *ids = rd->get_ids();
				ts = rd->get_typeSpec();
				process_locals(ts, ids);
				break;
				}
			case Decl::VarArgsDeclT: {
				VarArgsDecl *vd = (VarArgsDecl *)d;
				Id *id = vd->get_id();
				ts = vd->get_typeSpec();
				process_local(ts, id);
				break;
				}
			}
		break;
		}
	case ParseNode::TagWhenArmT: {
		TagWhenArm *twa = (TagWhenArm *)pn;
		srch_pn_for_locals(twa->get_decl());
		srch_pn_for_locals(twa->get_body());
		break;	
		}
	case ParseNode::TypeWhenArmT: {
		TypeWhenArm *twa = (TypeWhenArm *)pn;
		Id *id = twa->get_id();
		if (id) process_local(twa->get_typ(), id);
		srch_pn_for_locals(twa->get_body());
		break;	
		}
	case ParseNode::ExWhenArmT: {
		ExWhenArm *ewa = (ExWhenArm *)pn;
		srch_pnl_for_locals(ewa->get_decls());
		srch_pn_for_locals(ewa->get_body());
		break;	
		}
	case ParseNode::OthersHandlerT: {
		OthersHandler *oh = (OthersHandler *)pn;
		Id *id = oh->get_id();
		if (id) process_local(oh->get_typeSpec(), id);
		srch_pn_for_locals(oh->get_body());
		break;	
		}
	case ParseNode::ElseIfT: {
		ElseIf *els = (ElseIf *)pn;
		srch_pn_for_locals(els->get_body());
		break;	
		}
	case ParseNode::BodyT: {
		Body *b = (Body *)pn;
		srch_pnl_for_locals(b->get_statements());
		break;	
		}
	case ParseNode::StmtT: {
		Stmt *stmt = (Stmt *)pn;
		switch (stmt->tag()) {
		   case Stmt::DeclStmtT: {
			DeclStmt *d = (DeclStmt *)stmt;
			srch_pn_for_locals(d->get_decl());
			break;
			}
		   case Stmt::InitVarExprT: {
			InitVarExpr *ive = (InitVarExpr *)stmt;
			srch_pn_for_locals(ive->get_decl());
			break;
			}
		   case Stmt::InitVarInvokeT: {
			InitVarInvoke *ivi = (InitVarInvoke *)stmt;
			srch_pnl_for_locals(ivi->get_decls());
			break;
			}
		   case Stmt::DeclForStmtT: {
			DeclForStmt *dfs = (DeclForStmt *)stmt;
			srch_pnl_for_locals(dfs->get_decls());
			srch_pn_for_locals(dfs->get_body());
			break;
			}
		   case Stmt::ForStmtT: {
			ForStmt *fs = (ForStmt *)stmt;
			srch_pn_for_locals(fs->get_body());
			break;
			}
		   case Stmt::ExceptStmtT: {
			ExceptStmt *exs = (ExceptStmt *)stmt;
			srch_pn_for_locals(exs->get_stmt());
			srch_pnl_for_locals(exs->get_exWhenArm());
			srch_pn_for_locals(exs->get_decl());
			srch_pn_for_locals(exs->get_body());
			break;
			}
		   case Stmt::WhileStmtT: {
			WhileStmt *wh = (WhileStmt *)stmt;
			srch_pn_for_locals(wh->get_body());
			break;
			}
		   case Stmt::IfStmtT: {
			IfStmt *ifst = (IfStmt *)stmt;
			srch_pn_for_locals(ifst->get_body());
			srch_pnl_for_locals(ifst->get_elseifs());
			srch_pn_for_locals(ifst->get_elsebody());
			break;
			}
		   case Stmt::TypecaseT: {
			Typecase *tp = (Typecase *)stmt;
			srch_pnl_for_locals(tp->get_typeWhenArms());
			srch_pn_for_locals(tp->get_body());
			break;
			}
		   case Stmt::TagcaseT: {
			Tagcase *tg = (Tagcase *)stmt;
			srch_pnl_for_locals(tg->get_tagWhenArms());
			srch_pn_for_locals(tg->get_body());
			break;
			}
		   case Stmt::InitT: {
			Init *init = (Init *)stmt;
			srch_pn_for_locals(init->get_body());
			break;
			}
		   case Stmt::BlockStmtT: {
			BlockStmt *b = (BlockStmt *)stmt;
			srch_pn_for_locals(b->get_body());
			break;	
			}
		   case Stmt::ResignalStmtT: {
			ResignalStmt *rs = (ResignalStmt *)stmt;
			srch_pn_for_locals(rs->get_stmt());
			break;	
			}
		   }
		break;
		}
	}
   }

void process_locals(TypeSpec *ts, ParseNodeList *pnl)
{
   if (pnl) for (Pix p = pnl->first(); p ; pnl->next(p)){
	Id *id = (Id *)(*pnl)(p);
	process_local(ts, id);
	}
   }

void process_local(TypeSpec *ts, Id *id)
{
   TypeInterface *ti = ts->get_type();
   type t = ti->get_type();
   if (!t) { sprintf(cmp_err_buf, "Time to fix process_local (%s)", 
			id->get_id());
	     cmp_err(cmp_err_buf, id->get_line());
	     return;
	}
   save_local(type_name(t), id->get_id());
   }

static string local_names[100];
static string local_types[100];
static int local_name_index = 0;

void save_local(string typ, string id)
{
int i;
   for (i = 0; i < local_name_index ; i++) {
	if (string_equal(local_names[i], id)) return;
	}
   local_names[local_name_index] = id;
   local_types[local_name_index] = typ;
   local_name_index++;
   }

void clear_locals()
{
   local_name_index = 0;
   }

void output_locals()
{
int i;

   for (i = 0; i < local_name_index ; i++) {
	output_local(local_types[i], local_names[i]);
	}
   }

void output_local(string typ, string id)
{
string styp = simple_type_name(typ);

   pstr(styp);
   ps(" ");
   pstr(id);
   ps(";\n");
   }

bool anyize_it(Expr *ex2)
{
        TypeInterface *ti2 = ex2->get_type();
        type t2 = 0;
        if (ti2) t2 = ti2->get_type();
	if (!t2) {
		vec v = ti2->get_mult();
		if (v && vec_length(v)) t2 = UNPV(type, vec_fetch(v, 0));
		}
	if (t2 && (type_as_objtype(t2) == Any)) return FALSE;
	if (is_object (ex2)) { ps("obj_as_any((obj)"); return TRUE;}
        if (t2 && (t2 == class_as_type(Int))) 
			{ ps("int_as_any("); return TRUE; }
        if (t2 && (t2 == class_as_type(Bool))) 
			{ ps("bool_as_any("); return TRUE; }
        if (t2 && (t2 == class_as_type(Char))) 
			{ ps("char_as_any("); return TRUE; }
        if (t2 && (t2 == class_as_type(Null))) 
			{ ps("null_as_any("); return TRUE; }
        if (t2 && (t2 == class_as_type(Real))) 
			{ ps("real_as_any("); return TRUE; }
	return FALSE;	/* shouldn't happen... */
    }

bool anyize(ParseNode *pn, Expr *ex)
{
    TypeInterface *ti = 0;
    switch (pn->tag()) {
	case ParseNode::ExprT: {
    		Expr *ex1 = (Expr*)pn;
    		ti = ex1->get_type();
		break;
		}
	case ParseNode::DeclT: {
		Decl *d = (Decl *)pn;
    		ti = d->get_type();
		break;
		}
	case ParseNode::IdT: {
		Id *id = (Id *)pn;
    		ti = id->get_type();
		break;
		}
	}
    type t = 0;
    if (ti) t = ti->get_type();
    if (t && (type_as_objtype(t) == Any))
	return anyize_it(ex);
    return FALSE;
    }
